( function( $ ) {
    'use strict';

    /*Counter*/
    var counter = function () {
        var a = 0;
        $(window).scroll(function() {
            var oTop = $('.counter').offset().top - window.innerHeight;
            if ( a == 0 && $(window).scrollTop() > oTop ) {
                $('.number').each(function() {
                    var $this = $(this),
                    countTo = $this.attr('data-to');
                    $({
                        countNum: $this.text()
                    }).animate({
                        countNum: countTo
                    },

                    {
                    duration: 5000,
                    easing: 'swing',
                    step: function() {
                        $this.text(Math.floor(this.countNum));
                    },
                    complete: function() {
                        $this.text(this.countNum);
                    }
                    });
                });
                a = 1;
            }
        });
    }

    /*Team*/ 
    var resize = function ( $scope, $ ) {
        $scope.find( '.team-wrap.vertically' ).each( function () {
            
            var height = $(this).find('.team-thumb img').height();
            $(this).find('.team-hover').height(height);
            
        } );
    }

	/*Portfolio Filter*/
    var portfolioFilter = function () {
        $(window).load(function() {
            var $container = $('#projects');
            $container.isotope({
                itemSelector: '.project-item',
                filter: '*',
                masonry: {
                    columnWidth: 1,
                }
            });
            $('#filters a').on("click", function() {
                var $this = $(this);
                if ($this.hasClass('selected')) {
                    return false;
                }
                var $optionSet = $this.parents();
                $optionSet.find('.selected').removeClass('selected');
                $this.addClass('selected');
                var selector = $(this).attr('data-filter');
                $container.isotope({
                    filter: selector
                });
                return false;
            });
        });
    }

    /*Portfolio Slider*/

    var portfolioSlider = function ( $scope, $ ) {
        $scope.find( '.project-slider-wraper' ).each( function () {
            var $selector = $( this ).find( '.project-slider' ),
                $show = $selector.data('show'),
                $dots  = $selector.data('dots'),
                $arr = $selector.data('arrow'),
                $auto = $selector.data('auto');

            $selector.not( '.slick-initialized' ).slick( {
                infinite: true,
                slidesToShow: $show,
                slidesToScroll: 1,
                autoplay: $auto,
                autoplaySpeed: 7000,
                adaptiveHeight: true,
                prevArrow: '<button type="button" class="prev-nav"><i class="ion ion-md-arrow-back"></i></button>',
                nextArrow: '<button type="button" class="next-nav"><i class="ion ion-md-arrow-forward"></i></button>',
                arrows: $arr,
                dots: $dots,
                responsive: [
                    {
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                            infinite: true,
                            arrows: true,
                            dots: false
                        }
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                            infinite: true,
                            arrows: true,
                            dots: false
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true
                        }
                    }
                ]
            } );
        } );
    }

    /*Feature Portfolio Slider*/

    var featurePortfolioSlider = function ( $scope, $ ) {
        $scope.find( '.feature-project-wraper' ).each( function () {
            var $selector = $( this ).find( '.project-slider' ),
                $show = $selector.data('show'),
                $dots  = $selector.data('dots'),
                $arr = $selector.data('arrow'),
                $auto = $selector.data('auto');

            $selector.not( '.slick-initialized' ).slick( {
                infinite: true,
                slidesToShow: $show,
                slidesToScroll: 1,
                autoplay: $auto,
                autoplaySpeed: 7000,
                adaptiveHeight: true,
                prevArrow: '<button type="button" class="prev-nav"><i class="ion ion-md-arrow-back"></i></button>',
                nextArrow: '<button type="button" class="next-nav"><i class="ion ion-md-arrow-forward"></i></button>',
                arrows: $arr,
                dots: $dots,
                responsive: [
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            infinite: true,
                            arrows: true,
                            dots: false
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true
                        }
                    }
                ]
            } );
        } );
    }

	/*Testimonial Slider*/
    var testimonialSlider = function ( $scope, $ ) {
        $scope.find( '.testi-slider-wraper' ).each( function () {
            var $selector = $( this ).find( '.testi-slider' ),
                $show = $selector.data('show'),
                $dots  = $selector.data('dots'),
                $arr = $selector.data('arrow'),
                $auto = $selector.data('auto'),
                $m_show = $show;
                if( $show == 3 ) $m_show = $show - 1;

            $selector.not( '.slick-initialized' ).slick( {
                slidesToShow: $show,
                slidesToScroll: 1,
                arrows: $arr,
                dots: $dots,
                autoplay: $auto,
                autoplaySpeed: 7000,
                adaptiveHeight: true,
                prevArrow: '<button type="button" class="prev-nav"><i class="ion ion-md-arrow-back"></i></button>',
                nextArrow: '<button type="button" class="next-nav"><i class="ion ion-md-arrow-forward"></i></button>',
                responsive: [
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: $m_show,
                            slidesToScroll: 1,
                            infinite: true,
                            arrows: $arr,
                            dots: $dots
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true
                        }
                    }
                ]
            } );
        } );
    };
    

    /*Latest News*/
    var latestNews = function ( $scope, $ ) {
        $scope.find( '.news-slider-wraper' ).each( function () {
            var $selector = $( this ).find( '.news-slider' ),
                $show = $selector.data('show'),
                $dot  = $selector.data('dots'),
                $auto = $selector.data('auto'),
                $arrow = $selector.data('arrow'),
                $m_show = $show;

            $selector.not( '.slick-initialized' ).slick( {
                infinite: false,
                slidesToShow: $show,
                slidesToScroll: 1,
                arrows: $arrow,
                dots: $dot,
                autoplay: $auto,
                autoplaySpeed: 6000,
                prevArrow: '<button type="button" class="prev-nav"><i class="ion ion-md-arrow-back"></i></button>',
                nextArrow: '<button type="button" class="next-nav"><i class="ion ion-md-arrow-forward"></i></i></button>',
                responsive: [
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: true
                        }
                    },
                ]
            } );
        } );
    };

    /* Image Carousel */
    var imageCarousel = function ( $scope, $ ) {
        $scope.find( '.image-carousel-wraper' ).each( function () {
            var $selector = $( this ).find( '.image-carousel' ),
                $show    = $selector.data('show'),
                $m1_show  = ( $show < 5 ) ? $show : 4,
                $m2_show  = ( $show == 1 ) ? $show : 2,
                $dots    = $selector.data('dots'),
                $auto    = $selector.data('auto'),
                $arrow   = $selector.data('arrow');

            $selector.not( '.slick-initialized' ).slick( {
                infinite: true,
                slidesToShow: $show,
                slidesToScroll: 1,
                arrows: $arrow,
                dots: $dots,
                autoplay: $auto,
                autoplaySpeed: 6000,
                prevArrow: '<button type="button" class="prev-nav"><i class="ion ion-md-arrow-back"></i></button>',
                nextArrow: '<button type="button" class="next-nav"><i class="ion ion-md-arrow-forward"></i></i></button>',
                responsive: [
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: $m1_show,
                            slidesToScroll: 1,
                            arrows: true,
                            dots: false
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: $m2_show,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: false
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            arrows: false,
                            dots: false
                        }
                    }
                ]
            } );
        } );
    };
    
    /*Slider*/ 

    var slideCarousel = function ( $scope, $ ) {
        $scope.find( '.bigger-slides-wrapper' ).each( function () {
            var $selector = $( this ).find( '.bigger-slides' ),
                elementSettings = $selector.data( 'slider_options' ),
                $arrow_wrapper = $( this ).find( '.arrows-inner' ),
                slidesToShow = parseInt( elementSettings.slidesToShow );

            $selector.not( '.slick-initialized' ).slick( {
                rtl          : $( 'body' ).hasClass( 'rtl' ),
                slidesToShow : slidesToShow,
                arrows       : elementSettings.arrows,
                appendArrows : $arrow_wrapper,
                dots         : elementSettings.dots,
                infinite     : elementSettings.infinite,
                prevArrow    : '<span class="slick-prev-arrow"><i class="ion ion-md-arrow-back"></i></span>',
                nextArrow    : '<span class="slick-next-arrow"><i class="ion ion-md-arrow-forward"></i></span>',
                autoplay     : elementSettings.autoplay,
                autoplaySpeed: parseInt( elementSettings.autoplaySpeed ),
                speed        : parseInt( elementSettings.speed ),
                fade         : elementSettings.fade,
                pauseOnHover : elementSettings.pauseOnHover,
                responsive   : []
            } );

            var animation = $selector.data( 'animation' );

            
            $selector
                .on( 'beforeChange', function () {
                    var $sliderContent = $selector.find( '.bigger-slide-content' ),
                        $sliderBackground = $selector.find( '.slick-slide-bg' ),
                        $sliderPriceBox = $selector.find( '.bigger-slide-price-box' );
                    $sliderContent.each( function () {
                        var content_animation = $(this).data( 'animation' );
                        if( content_animation === 'inherit' ){
                            if( animation ){
                                $(this).removeClass( 'animated' + ' ' + animation ).hide();
                            }else{
                                $(this).hide();
                            }
                        }else{
                            $(this).removeClass( 'animated' + ' ' + content_animation ).hide();
                        }
                    } );

                    $sliderBackground.each( function () {
                        var bg_animation = $(this).data( 'animation' );
                        if( bg_animation === 'inherit' ){
                            if( animation ){
                                $(this).removeClass( 'animated' + ' ' + animation ).hide();
                            }else{
                                $(this).hide();
                            }
                        }else{
                            $(this).removeClass( 'animated' + ' ' + bg_animation ).hide();
                        }
                    } );

                } )
                .on( 'afterChange', function ( event, slick, currentSlide ) {
                    var $currentSlide = $( slick.$slides.get( currentSlide ) ),
                        current_content_animation = $currentSlide.find( '.bigger-slide-content' ).data('animation'),
                        current_bg_animation = $currentSlide.find( '.slick-slide-bg' ).data('animation'),
                        $currentPriceBox = $currentSlide.find( '.bigger-slide-price-box' );
                    if( current_content_animation === 'inherit' ){
                        if( animation ){
                            $currentSlide.find( '.bigger-slide-content' ).show().addClass( 'animated' + ' ' + animation );
                        }else{
                            $currentSlide.find( '.bigger-slide-content' ).show();
                        }
                    }else{
                        $currentSlide.find( '.bigger-slide-content' ).show().addClass( 'animated' + ' ' + current_content_animation );
                    }

                    if( current_bg_animation === 'inherit' ){
                        if( animation ){
                            $currentSlide.find( '.slick-slide-bg' ).show().addClass( 'animated' + ' ' + animation );
                        }else{
                            $currentSlide.find( '.slick-slide-bg' ).show();
                        }
                    }else{
                        $currentSlide.find( '.slick-slide-bg' ).show().addClass( 'animated' + ' ' + current_bg_animation );
                    }
                } );
        } );
    };



    /**
     * Elementor JS Hooks
     */
    $(window).on("elementor/frontend/init", function () {
        /*Portfolio Slide*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/bigger-slider-portfolio.default",
            portfolioSlider
        );

        /*Portfolio Feature*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/bigger-feature-project.default",
            featurePortfolioSlider
        );

        /*Counter*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/bigger-fun-facts.default",
            counter
        );

        /*Team*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/bteam.default",
            resize
        );

        /*Portfolio Filter*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/bigger-portfolio-filter.default",
            portfolioFilter
        );

        /*Testimonial Slider*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/bigger-testimonial.default",
            testimonialSlider
        );

        /*Latest News*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/bigger-news-slider.default",
            latestNews
        );

        /*Slider*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/bigger-slider.default",
            slideCarousel
        );

        /*Image Carousel*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/bigger-image-carousel.default",
            imageCarousel
        );

    });

} )( jQuery );
