<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Bigger
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function bigger_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Add a class if there is a custom header.
	if ( bigger_get_option('preload') != false ){
		$classes[] = 'royal_preloader';
	}

	return $classes;
}
add_filter( 'body_class', 'bigger_body_classes' );

// Add specific CSS class to header
function bigger_header_class() {

	$header_classes = array();

	if ( bigger_get_option('header_desktop_sticky') != false ){ 
		$header_classes[] = 'sticky-header'; 
	}

	if ( bigger_get_option('header_mobile_sticky') != false ){ 
		$header_classes[] = 'mobile-header-sticky'; 
	}

	if( bigger_get_option('hmobile_style') == "styleblue" ){
		$header_classes[] = 'mobile-header-blue'; 
	}elseif( bigger_get_option('hmobile_style') == "styledark" ) {
		$header_classes[] = 'mobile-header-dark'; 
	}else{
		$header_classes[] = 'mobile-header-light'; 
	}

	if( bigger_get_option('header_layout') == "header2" ){
		$header_classes[] = 'header-style-2';
	}elseif( bigger_get_option('header_layout') == "header3" ) {
		$header_classes[] = 'header-style-3';
	}elseif( bigger_get_option('header_layout') == "header4" ) {
		$header_classes[] = 'header-style-4';
	}else{
		$header_classes[] = 'header-style-1';
	}
	if ( is_front_page() && !is_home() ) {
		if ( bigger_get_option('home_header_transperant_switch') == true ){ 
			$header_classes[] = 'header-transparent header-fixed'; 
		}
	}

    // return the $classes array
    echo implode( ' ', $header_classes );
}

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function bigger_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'bigger_pingback_header' );

//Get layout post & page.
if ( ! function_exists( 'bigger_get_layout' ) ) :
	function bigger_get_layout() {
		// Get layout.
		if( is_singular('ot_service') || is_singular('ot_portfolio') || is_page() && !is_home() ) {
			if ( function_exists('rwmb_meta') ) {
				$page_layout = rwmb_meta('page_layout');
			}
		}elseif( is_single() ){
			$page_layout = bigger_get_option( 'single_post_layout' );
		}else{
			$page_layout = bigger_get_option( 'blog_layout' );
		}

		return $page_layout;
	}
endif;

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
if ( ! function_exists( 'bigger_content_columns' ) ) :
	function bigger_content_columns() {

		$blog_content_width = array();

		// Check if layout is one column.
		if ( 'content-sidebar' === bigger_get_layout() && is_active_sidebar( 'primary' ) ) {
			$blog_content_width[] = 'col-lg-8 col-md-8 col-sm-12 col-xs-12';
		}elseif ('sidebar-content' === bigger_get_layout() && is_active_sidebar( 'primary' ) ) {
			$blog_content_width[] = 'col-lg-8 col-md-8 col-sm-12 col-xs-12 pull-right';
		}else{
			$blog_content_width[] = 'col-lg-12 col-md-12 col-sm-12 col-xs-12';
		}

		// return the $classes array
    	echo implode( ' ', $blog_content_width );
	}
endif;

if(!function_exists('bigger_custom_frontend_scripts')){
    function bigger_custom_frontend_scripts(){
    ?>  
      <?php if ( bigger_get_option('preload') != false ){ ?>
        <script type="text/javascript">
            window.jQuery = window.$ = jQuery;  
            (function($) { "use strict";
            	//Preloader
				Royal_Preloader.config({
					mode           : 'logo',
					logo           : '<?php echo bigger_get_option('preload_logo'); ?>',
					logo_size      : [<?php echo bigger_get_option('preload_logo_width'); ?>, <?php echo bigger_get_option('preload_logo_height'); ?>],
					showProgress   : true,
					showPercentage : true,
			        text_colour: '<?php echo bigger_get_option('preload_text_color'); ?>',
                    background:  '<?php echo bigger_get_option('preload_bgcolor'); ?>'
				});
            })(jQuery);
        </script>
    <?php } ?>          
<?php        
    }
}
add_action('wp_footer', 'bigger_custom_frontend_scripts');