<?php
if ( ! function_exists( 'bigger_page_header' ) ) {
    function bigger_page_header (){
        $pheader = '';
        if ( function_exists('rwmb_meta') ) {
            if( is_home() || is_singular('post') || is_archive() || is_search() ){
                $pheader = rwmb_meta('pheader_switch', "type=switch", get_option( 'page_for_posts' ));
                if( class_exists( 'WooCommerce' ) ){
                    if( is_shop() || is_product_category() || is_product_tag() || is_singular('product') ){
                        $pheader = rwmb_meta('pheader_switch', "type=switch", get_option( 'woocommerce_shop_page_id' ));
                    }
                }
            }elseif( is_singular('product') ){
                $pheader = rwmb_meta('pheader_switch', "type=switch", get_option( 'woocommerce_shop_page_id' ));
            }else{
                $pheader = rwmb_meta('pheader_switch');
            }
            if( !$pheader || is_404() ){
                return;
            }
        }
        if( !bigger_get_option('pheader_switch') && !$pheader ) {
            return;
        }else{
            $bg     = '';
            $title  = '';
            $output = array();

            if ( is_home() ) {
                $title = get_the_title(get_option('page_for_posts'));
            } elseif ( is_search() ) {
                $title = esc_html__('Search Results for: ', 'bigger') . get_search_query();
            } elseif ( is_archive() ) {
                $title = get_the_archive_title();
            } else {
                $title = get_the_title();
            }
            
            if (!function_exists('rwmb_meta')) {
                $bg = bigger_get_option( 'pheader_img' );
            } else {
                if( is_home() ) {
                    $images = rwmb_meta('pheader_bg_image', "type=image", get_option( 'page_for_posts' ));
                }elseif( class_exists( 'WooCommerce' ) && is_shop() ){
                    $images = rwmb_meta('pheader_bg_image', "type=image", get_option( 'woocommerce_shop_page_id' ));
                }else{
                    $images = rwmb_meta('pheader_bg_image', "type=image");
                }
                if (!$images) {
                    $bg = bigger_get_option( 'pheader_img' );
                } else {
                    foreach ($images as $image) {
                        $bg = $image['full_url'];
                        break;
                    }
                }
            }

            if ($title) {
                $output[] = sprintf('%s', $title);
            }
            $text_align = '';
            if( bigger_get_option('pheader_text_align') == "left" ){
                $text_align = 'text-left';
            }elseif( bigger_get_option('pheader_text_align') == "right" ) {
                $text_align = 'text-right';
            }else{
                $text_align = 'text-center';
            }

        ?>
        <?php if( bigger_get_option('pheader_switch') !== false ){ ?>
        <div class="page-header" <?php if ($bg) { ?> style="background-image: url(<?php echo esc_url($bg); ?>);" <?php } ?>>
            <div class="container">
                <div class="breadc-box">
                    <div class="row dflex">
                        <div class="col-md-12 <?php echo esc_attr( $text_align ); ?>">
                            <?php if( class_exists( 'WooCommerce' ) && is_shop() ) { ?>
                                    <h2 class="page-title"><?php woocommerce_page_title(); ?></h2>
                                <?php }else{ ?>
                                    <h2 class="page-title"><?php echo implode('', $output); ?></h2>
                                <?php } ?>
                                <?php 
                                    if (function_exists('bigger_breadcrumbs') && bigger_get_option('breadcrumbs')):
                                        echo bigger_breadcrumbs();
                                    endif;
                                ?>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
        <?php }
        }
    }
}