<!-- Top bar start -->
<?php if( bigger_get_option('topbar_switch') != false ){ ?>
<div id="header_topbar" class="top-bar md-hidden sm-hidden">
	<div class="container container-bigger">
		<div class="inner-top dtable">
			<div id="logo-header" class="site-logo dcell">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
					<img <?php if ( bigger_get_option('logo_scroll') != '' ) { ?>class="logo-static"<?php } ?> src="<?php echo bigger_get_option('logo') ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
					<?php if ( bigger_get_option('logo_scroll') && bigger_get_option('header_desktop_sticky') ) { ?>
						<img class="logo-scroll" src="<?php echo bigger_get_option('logo_scroll') ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
					<?php } ?>
				</a>
			</div>
			<?php if ( bigger_get_option('info_switch') != false ){ 
				$contact_infos = bigger_get_option( 'header_contact_info', array() );
				if( $contact_infos ){
			?>
			<div class="info-top dcell"><!-- contact info -->
				<ul class="info-list unstyle">
					<?php foreach ( $contact_infos as $contact_info ) { ?>
						<li>
							<?php if($contact_info['info_icon'] != '') echo wp_specialchars_decode($contact_info['info_icon']); ?>
							<?php echo wp_specialchars_decode($contact_info['info_content']); ?>
						</li>
					<?php } ?>
				</ul><!-- contact info close -->
			</div>
			<?php } } ?>

			<div class="search-cart-box dcell"><!-- Search - Cart  -->

				<?php if ( bigger_get_option('search_switch') != false ){ ?>
					<div class="toggle_search f-right"><i class="fas fa-search"></i></div>
					<div class="h-search-form-field">
						<?php get_search_form(); ?>
					</div>	
				<?php } ?>

				<?php if ( class_exists( 'woocommerce' ) ) {?>
				<div class="h-cart-btn f-right">
					<a class="cart-contents" href=""><i class="fas fa-shopping-cart"></i></a>
				</div>
				<?php } ?>

			</div><!-- Search - Cart Close  -->

			<?php  $btns = bigger_get_option( 'cta_top', array() ); if( $btns ){ ?>
			<div class=" btn-cta-header dcell text-right"><!-- Button Contact  -->
				<?php foreach( $btns as $btn ){ ?>
					<a href="<?php echo esc_url($btn['btn_link']); ?>" class="btn"><?php echo esc_html($btn['btn_text']); ?></a>
				<?php } ?>
			</div><!-- Button Contact close  -->
			<?php } ?>
		</div>
	</div>
</div>
<?php } ?>
<!-- Top bar close -->
<!-- Main header start -->
<div class="main-header md-hidden sm-hidden">
	<div class="container container-bigger">
		<div class="dtable">
			<div class="header-mainnav dcell">
				<nav id="site-navigation" class="main-navigation">			
					<?php
						wp_nav_menu( array(
							'theme_location' => 'primary',
							'menu_id'        => 'primary-menu',
							'menu_class'     => 'menu dtable',
							'container'		 => '',
						) );
					?>
				</nav><!-- #site-navigation -->
			</div>
		</div>
	</div>
</div>
<!-- Main header close -->