<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Testimonial 
 */
class Bigger_Testimonial extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-testimonial';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Testimonial', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-testimonial';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'bigger' ),
			]
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'photo', [
				'label' => __( 'Client Photo', 'bigger' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri() . '/images/testi1.png',
				],
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'name', [
				'label' => __( 'Client Name', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Harry Kane' , 'bigger' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'job', [
				'label' => __( 'Client Job', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Manager Ocean company' , 'bigger' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'des', [
				'label' => __( 'Client Say', 'bigger' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( '"I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine."' , 'bigger' ),
				'show_label' => false,
			]
		);
		$this->add_control(
			'testis',
			[
				'label' => __( 'List Testimonial', 'bigger' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'name' => __( 'Harry Kane', 'bigger' ),
						'photo'=> [
							'url'=>	get_template_directory_uri() . '/images/testi1.png',
						]
					],
					[
						'name' => __( 'Roger Federer', 'bigger' ),
						'photo'=> [
							'url'=>	get_template_directory_uri() . '/images/testi2.png',
						]
					],
					[
						'name' => __( 'Selena William', 'bigger' ),
						'photo'=> [
							'url'=>	get_template_directory_uri() . '/images/testi1.png',
						]
					],

				],
				'title_field' => '{{{ name }}}',
			]
		);

		$this->end_controls_section();

		//Setting
		$this->start_controls_section(
			'section_setting_content',
			[
				'label' => __( 'Setting', 'bigger' ),
				'tab' => Controls_Manager::TAB_SETTINGS,
			]
		);

		$this->add_control(
			'desc_align',
			[
				'label'     => esc_html__( 'Client Says Alignment', 'bigger' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'bottom',
				'options'   => [
					'top'     => esc_html__( 'Top', 'bigger' ),
					'bottom'   => esc_html__( 'Bottom', 'bigger' ),
				],
			]
		);

		$this->add_control(
			'number',
			[
				'label' => __( 'Slide To Show', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'default' => '2',
				'options' => [
					'2' => __( '2', 'bigger' ),
					'3' => __( '3', 'bigger' ),
					'1' => __( '1', 'bigger' ),
				],
			]
		);

		$this->add_control(
            'auto',
            [
                'label' => esc_html__('Autoplay', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'bigger'),
                'label_off' => esc_html__('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

		$this->add_control(
			'arrow',
			[
				'label' => __( 'Arrows Slide', 'bigger' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'bigger' ),
				'label_off' => __( 'Hide', 'bigger' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);

		$this->add_control(
			'dots',
			[
				'label' => __( 'Dots Slide', 'bigger' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'bigger' ),
				'label_off' => __( 'Hide', 'bigger' ),
				'return_value' => 'true',
				'default' => '',
			]
		);

		$this->add_control(
            'display_line',
            [
                'label' => __('Display Line', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bigger'),
                'label_off' => __('Hidden', 'bigger'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition'	=> [
                	'desc_align' => 'bottom'
                ]
            ]
        );

		$this->end_controls_section();

		// Content.
		$this->start_controls_section(
			'section_style_content',
			[
				'label' => __( 'Testimonial Header', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'content_space',
			[
				'label' => esc_html__( 'Spacing (px)', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .testi-slider.style-2 .testi-content h4, {{WRAPPER}} .testi-slider.style-1 .testi-head' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'content_color',
			[
				'label' => __( 'Text Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .testi-content p' => 'color: {{VALUE}};',
					'{{WRAPPER}} .testi-slider.style-2 .testi-content h4' => 'color: {{VALUE}};'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .testi-content p, {{WRAPPER}} .testi-slider.style-2 .testi-content h4',
			]
		);

		$this->end_controls_section();

		// Image.
		$this->start_controls_section(
			'section_style_image',
			[
				'label' => __( 'Image', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'image_space',
			[
				'label' => esc_html__( 'Spacing (px)', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .testi-head img' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'image_size',
			[
				'label' => __( 'Image Size (%)', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
				],
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .testi-head img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_border',
				'selector' => '{{WRAPPER}} .testi-head img',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'image_border_radius',
			[
				'label' => __( 'Border Radius', 'bigger' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .testi-head img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Name.
		$this->start_controls_section(
			'section_style_name',
			[
				'label' => __( 'Name', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'name_space',
			[
				'label' => esc_html__( 'Spacing (px)', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .testi-head h6 span' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'name_text_color',
			[
				'label' => __( 'Text Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .testi-head h6' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography',
				'selector' => '{{WRAPPER}} .testi-head h6',
			]
		);

		$this->end_controls_section();

		// Job.
		$this->start_controls_section(
			'section_style_job',
			[
				'label' => __( 'Job', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'job_text_color',
			[
				'label' => __( 'Text Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .testi-head h6 span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'job_typography',
				'selector' => '{{WRAPPER}} .testi-head h6 span',
			]
		);

		$this->end_controls_section();

		//Border
		$this->start_controls_section(
			'section_style_border',
			[
				'label' => __( 'Border', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'testi_border',
				'label' => __( 'Border', 'bigger' ),
				'selector' => '{{WRAPPER}} .testi-item',
			]
		);

		$this->add_control(
			'testi_border_radius',
			[
				'label' => __( 'Border Radius', 'bigger' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .testi-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		//Line
		$this->start_controls_section(
			'section_style_line',
			[
				'label' => __( 'Line', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'desc_align'   => 'bottom',
					'display_line' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'line_space',
			[
				'label' => esc_html__( 'Spacing (px)', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .is-line' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'line_width',
			[
				'label' => __( 'Line Width (px)', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 485,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .is-line' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'line_height',
			[
				'label' => __( 'Line Height (px)', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .is-line' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
            'line_color',
            [
                'label' => __( 'Line Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .is-line' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'navigation_section',
			[
				'label' => __( 'Navigation', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'arrow_style',
			[
				'label' => __( 'Arrow', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'condition' => [
					'arrow' => 'true'
				]
			]
		);

		$this->add_control(
            'arrow_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-slider .slick-arrow' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'arrow' => 'true'
				]
            ]
        );


		$this->add_control(
            'arrow_color_hover',
            [
                'label' => __( 'Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-slider .slick-arrow:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'arrow' => 'true'
				]
            ]
        );

        $this->add_control(
            'bg_arrow_color',
            [
                'label' => __( 'Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-slider .slick-arrow' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'arrow' => 'true'
				]
            ]
        );

        $this->add_control(
            'arrow_bg_color_hover',
            [
                'label' => __( 'Hover Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-slider .slick-arrow:hover' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'arrow' => 'true'
				]
            ]
        );

        $this->add_control(
			'dot_style',
			[
				'label' => __( 'Dot', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'dots' => 'true'
				]
			]
		);

		$this->add_control(
            'dot_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-slider .slick-dots li button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'dots' => 'true'
				]
            ]
        );

        $this->add_control(
            'dot_color_active',
            [
                'label' => __( 'Color Active', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-slider .slick-dots li.slick-active button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'dots' => 'true'
				]
            ]
        );

        $this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		// echo "<pre>";print_r($settings['arrow']);die;
		?>
		<div class="testi-slider-wraper">
			<div class="testi-slider <?php if( $settings['desc_align'] =='bottom' ){ echo 'style-1';}else{ echo 'style-2'; } ?>" data-show="<?php echo esc_attr( $settings['number'] ); ?>" data-arrow="<?php echo esc_attr( $settings['arrow'] ); ?>" data-dots="<?php echo esc_attr( $settings['dots'] ); ?>" data-auto="<?php echo esc_attr( $settings['auto'] ); ?>">
				<?php 
					foreach ($settings['testis'] as $key => $testi) {
				?>
				<div>
	                <div class="testi-item">
	                	<?php if( $settings['desc_align'] == 'bottom' ){ ?>

	                    <div class="testi-head">
	                        <img src="<?php echo esc_attr( $testi['photo']['url'] ); ?>" alt="">
	                        <h6><?php echo esc_attr( $testi['name'] ); ?><span class="font12 normal"><?php echo esc_attr( $testi['job'] ); ?></span></h6>
	                    </div>
	                    <?php if( $settings['display_line'] ){ ?><div class="is-line"></div><?php } ?>
	                    <div class="testi-content">
	                        <p><?php echo esc_attr( $testi['des'] ); ?></p>
	                    </div>

	                	<?php }else{ ?>
	            		<div class="testi-content">
	                        <h4><?php echo esc_attr( $testi['des'] ); ?></h4>
	                    </div>
	                    <div class="testi-head">
	                        <img src="<?php echo esc_attr( $testi['photo']['url'] ); ?>" alt="">
	                        <h6><?php echo esc_attr( $testi['name'] ); ?><span class="font12 normal"><?php echo esc_attr( $testi['job'] ); ?></span></h6>
	                    </div>
	                	<?php } ?>
	                </div>
	            </div>
	        	<?php } ?>
			</div>
		</div>
		<?php 
		
	}

	protected function _content_template() {}
}
// After the Bigger_Testimonial class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Testimonial() );