<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Fun facts 
 */
class Bigger_Team extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bteam';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Team', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-icon-box';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Team Content', 'bigger' ),
			]
		);

		$this->add_control(
	       'member_image',
	        [
	           'label' => esc_html__( 'Member Image', 'bigger' ),
	           'type'  => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
			  	],
		    ]
	    );



	    $this->add_control(
		    'member_name',
	      	[
	          'label' => esc_html__( 'Member Name', 'bigger' ),
	          'type'  => Controls_Manager::TEXTAREA,
	          'default' => esc_html__( 'Jonathan Morgan', 'bigger' ),
	    	]
	    );

	    $this->add_control(
            'link',
            [
                'label' => esc_html__( 'Link To', 'bigger' ),
                'type'  => Controls_Manager::URL,
                'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://your-link.com', 'bigger' ),
				'default' => [
					'url' => 'https://your-link.com', 
				],
            ]
        );

        $this->add_responsive_control(
            'align_item',
            [
                'label' => esc_html__( 'Align Member Team', 'bigger' ),
                'type'  => Controls_Manager::SELECT,
				'default' => 'horizontal',
				'options' => [
					'horizontal' =>  __( 'Horizontal', 'bigger' ),
					'vertically' =>  __( 'Vertically', 'bigger' ),
				],
            ]
        );

        $this->add_control(
            'align_image_h',
            [
                'label' => esc_html__( 'Align Member Image', 'bigger' ),
                'type'  => Controls_Manager::SELECT,
				'default' => 'right',
				'options' => [
					'right' =>  __( 'Left', 'bigger' ),
					'left' =>  __( 'Right', 'bigger' ),
				],
				'condition' => [
					'align_item' => 'horizontal',
				],
            ]
        );

        $this->add_control(
            'align_image_v',
            [
                'label' => esc_html__( 'Align Member Image', 'bigger' ),
                'type'  => Controls_Manager::SELECT,
				'default' => 'bottom',
				'options' => [
					'bottom' => __( 'Top', 'bigger' ),
					'top' 	 => __( 'Bottom', 'bigger' ),
				],
				'condition' => [
					'align_item' => 'vertically',
				],
            ]
        );

		$repeater = new Repeater();

	    $repeater->add_control(
	      	'title',
		    [
		        'label'   => esc_html__( 'Social Name', 'bigger' ),
		        'type'    => Controls_Manager::TEXT,
		        'default' => esc_html__( 'Facebook', 'bigger' ),
		    ]
	    );


		$repeater->add_control(
            'social_link',
            [
                'label' => esc_html__( 'Social Link', 'bigger' ),
                'type'  => Controls_Manager::URL,
                'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://www.facebook.com/', 'bigger' ),
				'default' => [
					'url' => 'https://www.facebook.com/', 
				],
            ]
        );

        $repeater->add_control(
            'social_icon',
            [
                'label' => esc_html__( 'Social Icon', 'bigger' ),
                'type'  => Controls_Manager::ICON,
                'default' => 'fa fa-facebook',
            ]
        );


		$this->add_control(
		    'social_share',
		    [
		        'label'       => esc_html__( 'Social Share', 'bigger' ),
		        'type'        => Controls_Manager::REPEATER,
		        'show_label'  => true,
		        'default'     => [
		            [
		             	'title'       => esc_html__( 'Facebook', 'bigger' ),
		                'social_link' => esc_html__( 'https://www.facebook.com/', 'bigger' ),
		                'social_icon' => 'fa fa-facebook',
		 
		            ],
		            [
		              	'title'       => esc_html__( 'Twitter', 'bigger' ),
		                'social_link' => esc_html__( 'https://www.twitter.com/', 'bigger' ),
		                'social_icon' => 'fa fa-twitter',
		 
		            ],
		            [
		              	'title'       => esc_html__( 'Linkedin', 'bigger' ),
		                'social_link' => esc_html__( 'https://www.linkedin.com/', 'bigger' ),
		                'social_icon' => 'fa fa-linkedin',
		            ]
		        ],
		        'fields'      => array_values( $repeater->get_controls() ),
		        'title_field' => '{{{title}}}',
		    ]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__( 'Title', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#404040',
				'selectors' => [
					'{{WRAPPER}} .team-wrap .team-info .team-title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .team-wrap .team-info .team-title:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'label'    => esc_html__( 'Typography', 'bigger' ),
					'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .team-wrap .team-info .team-title',
				]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'icon_style',
			[
				'label' => esc_html__( 'Social Icon', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Font Size', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [
					'size' => 14,
				],
				'range' => [
					'px' => [
						'min' => 12,
						'max' => 30,
					],
				],
				'selectors' => [
					'{{WRAPPER}}  .team-wrap .team-social a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_padding',
			[
				'label' => __( 'Padding', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .team-wrap .team-social a' => 'padding: {{SIZE}}{{UNIT}};',
				],
				'default' => [
					'unit' => 'px',
				],
				'tablet_default' => [
					'unit' => 'px',
				],
				'mobile_default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
					],
				],
			]
		);

		$this->add_responsive_control(
			'icon_space',
			[
				'label' => esc_html__( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [
					'size' => 10,
				],
				'range' => [
					'px' => [
						'min' => -10,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .team-wrap .team-social a:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_control(
	        'border_radius',
	        [
	            'label' => esc_html__( 'Border Radius', 'bigger' ),
	            'type'  => Controls_Manager::DIMENSIONS,
	            'size_units' => [ 'px', '%' ],
	            'selectors'  => [
	                '{{WRAPPER}} .team-wrap .team-social a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	            ],
	        ]
	    );


		$this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#8c8c8c',
				'selectors' => [
					'{{WRAPPER}} .team-wrap .team-social a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_bg_color',
			[
				'label'     => esc_html__( 'Bg Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .team-wrap .team-social a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#b7b7b7',
				'selectors' => [
					'{{WRAPPER}} .team-wrap .team-social a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_hover_bg_color',
			[
				'label'     => esc_html__( 'Hover Background Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ed485f',
				'selectors' => [
					'{{WRAPPER}} .team-wrap .team-social a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$align_item = $settings['align_item'];
		$align_image = ( $align_item == 'horizontal') ? $settings['align_image_h'] : $settings['align_image_v'];
		?>
		
        <div class="team-wrap <?php echo esc_attr( $align_item ); ?>">
        	<?php if( $align_image == 'right' || $align_image == 'bottom' ){ ?>
            <div class="team-thumb">
                <img src="<?php echo $settings['member_image']['url'];?>" alt="<?php echo $settings['member_name'];?>">                
            </div>
        	<?php }else{ ?>
        	<div class="team-hover <?php echo esc_attr( $align_image ); ?>">
            	<img src="http://localhost/bigger/wp-content/uploads/2019/07/symbol-hover.png">
            </div>
        	<?php } ?>
            <div class="team-info">
            	<div>
	                <div class="name">
	                    <?php if ( ! empty( $settings['member_name'] ) ) : ?>
	                        <?php if ( ! empty( $settings['link'] ) ) : ?>        
	                            <a class="team-title"<?php if( $settings['link'] ['is_external'])
	                                    { echo 'target="_blank"'; }else{ echo 'rel="nofollow"';}?>  
	                                    href="<?php  echo $settings['link']['url'];?>">
	                            <?php echo $settings['member_name'];?>
	                            </a>
	                        <?php endif; ?>
	                    <?php endif; ?>
	                </div>

	                <?php if ( ! empty( $settings['social_share'] ) ) : ?>
	                    <div class="team-social">
	                        <?php foreach ( $settings['social_share'] as $social ) : ?>
	                            <?php if ( ! empty( $social['social_link'] ) ) : ?>
	                                <a <?php if($social['social_link'] ['is_external'])
	                                { echo 'target="_blank"'; }else{ echo 'rel="nofollow"';}?> 
	                                        href="<?php  echo $social['social_link']['url'];?>" class="<?php  echo strtolower($social['title']);?>">
	                                     <i class="<?php echo esc_attr( $social['social_icon']); ?>"></i>
	                                </a>
	                            <?php endif; ?>
	                        <?php endforeach; ?>
	                    </div>  
	                <?php endif; ?>
                </div>
            </div><!-- end .hover content -->
            <?php if( $align_image == 'right' || $align_image == 'bottom' ){ ?>
            
            <div class="team-hover <?php echo esc_attr( $align_image ); ?>">
            	<img src="http://localhost/bigger/wp-content/uploads/2019/07/symbol-hover.png">
            </div>

        	<?php }else{ ?>

        	<div class="team-thumb">
                <img src="<?php echo $settings['member_image']['url'];?>" alt="<?php echo $settings['member_name'];?>">                
            </div>

        	<?php } ?>
        </div><!-- end .team wrap -->
	        
	    <?php
	}

	protected function _content_template() {}
}
// After the Bigger_Team class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Team() );