<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Fun facts 
 */
class Bigger_Pricing extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-pricing-table';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Pricing', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-price-table';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content_2_image',
			[
				'label' => esc_html__( 'Icon Image', 'bigger' ),
			]
		);

		$this->add_control(
			'pricing_image',
			[
				'label' => esc_html__( 'Icon Image', 'bigger' ),
				'type'  => Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri() . '/images/pricing1.png',
				],
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
            'section_header',
            [
                'label' => esc_html__( 'Title', 'bigger' ),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'bigger' ),
                'type'  => Controls_Manager::TEXT,
                'default' => esc_html__( 'New project', 'bigger' ),
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_pricing',
            [
                'label' => esc_html__( 'Pricing', 'bigger' ),
            ]
        );

        $this->add_control(
            'currency_symbol',
            [
                'label' => esc_html__( 'Currency Symbol', 'bigger' ),
                'type'  => Controls_Manager::SELECT,
                'options' => [
                    ''    => esc_html__( 'None', 'bigger' ),
                    'dollar' => '&#36; ' . _x( 'Dollar', 'Currency Symbol', 'bigger' ),
                    'euro'   => '&#128; ' . _x( 'Euro', 'Currency Symbol', 'bigger' ),
                    'baht'   => '&#3647; ' . _x( 'Baht', 'Currency Symbol', 'bigger' ),
                    'franc'  => '&#8355; ' . _x( 'Franc', 'Currency Symbol', 'bigger' ),
                    'guilder'=> '&fnof; ' . _x( 'Guilder', 'Currency Symbol', 'bigger' ),
                    'krona'  => 'kr ' . _x( 'Krona', 'Currency Symbol', 'bigger' ),
                    'lira'   => '&#8356; ' . _x( 'Lira', 'Currency Symbol', 'bigger' ),
                    'peseta' => '&#8359 ' . _x( 'Peseta', 'Currency Symbol', 'bigger' ),
                    'peso'   => '&#8369; ' . _x( 'Peso', 'Currency Symbol', 'bigger' ),
                    'pound'  => '&#163; ' . _x( 'Pound Sterling', 'Currency Symbol', 'bigger' ),
                    'real'   => 'R$ ' . _x( 'Real', 'Currency Symbol', 'bigger' ),
                    'ruble'  => '&#8381; ' . _x( 'Ruble', 'Currency Symbol', 'bigger' ),
                    'rupee'  => '&#8360; ' . _x( 'Rupee', 'Currency Symbol', 'bigger' ),
                    'shekel' => '&#8362; ' . _x( 'Shekel', 'Currency Symbol', 'bigger' ),
                    'yen'    => '&#165; ' . _x( 'Yen/Yuan', 'Currency Symbol', 'bigger' ),
                    'won'    => '&#8361; ' . _x( 'Won', 'Currency Symbol', 'bigger' ),
                    'custom' => esc_html__( 'Custom', 'bigger' ),
                ],
                'default' => 'dollar',
            ]
        );

        $this->add_control(
            'currency_symbol_custom',
            [
                'label' => esc_html__( 'Custom Symbol', 'bigger' ),
                'type'  => Controls_Manager::TEXT,
                'condition' => [
                    'currency_symbol' => 'custom',
                ],
            ]
        );

        $this->add_control(
            'price',
            [
                'label' => esc_html__( 'Price', 'bigger' ),
                'type'  => Controls_Manager::TEXT,
                'default' => '99',
            ]
        );

        $this->add_control(
            'period',
            [
                'label' => esc_html__( 'Period', 'bigger' ),
                'type'  => Controls_Manager::TEXT,
                'default' => '/ mon',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_features',
            [
                'label' => esc_html__( 'Features', 'bigger' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'item_text',
            [
                'label'   => esc_html__( 'Text', 'bigger' ),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'List Item', 'bigger' ),
            ]
        );

        $this->add_control(
            'features_list',
            [
                'type'    => Controls_Manager::REPEATER,
                'fields'  => array_values( $repeater->get_controls() ),
                'default' => [
                    [
                        'item_text' => esc_html__( 'General contracting', 'bigger' ),
                    ],
                    [
                        'item_text' => esc_html__( 'Pre-sales services', 'bigger' ),
                    ],
                    [
                        'item_text' => esc_html__( 'Expert consulting', 'bigger' ),
                    ],
                    [
                        'item_text' => esc_html__( 'Assistance', 'bigger' ),
                    ],
                    [
                        'item_text' => esc_html__( 'Business advises', 'bigger' ),
                    ],
                    [
                        'item_text' => esc_html__( 'Design & build', 'bigger' ),
                    ],
                    [
                        'item_text' => esc_html__( '24/7 support', 'bigger' ),
                    ]
                ],
                'title_field' => '{{{ item_text }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_footer',
            [
                'label' => esc_html__( 'Button', 'bigger' ),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'   => esc_html__( 'Button Text', 'bigger' ),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__( 'Order now', 'bigger' ),
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__( 'Link', 'bigger' ),
                'type'  => Controls_Manager::URL,
                'placeholder' => 'http://your-link.com',
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_layout_style',
            [
                'label' => esc_html__( 'Layout', 'bigger' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            ]
        );

        $this->add_control(
            'layout_position',
            [
                'label' => esc_html__( 'Alignment', 'bigger' ),
                'type'  => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options'  => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bigger' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bigger' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bigger' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'	=>	'center',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'layout_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#f9f9f9',
                'selectors' => [
                    '{{WRAPPER}} .tgx-price-table' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(), [
                'name'  => 'layout_border',
                'label' => esc_html__( 'Border', 'bigger' ),
                'placeholder' => '1px',
                'default'   => '1px',
                'selector'  => '{{WRAPPER}} .bigger-price-table',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'    => 'layout_box_shadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .bigger-price-table',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
	        'section_image_style',
            [
                'label' => esc_html__( 'Icon Image', 'bigger' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            ]
        );

		
	    $this->add_control(
            'pricing_imge_alignment',
            [
                'label' => esc_html__( 'Alignment', 'bigger' ),
                'type'  => Controls_Manager::CHOOSE,
                'label_block' => false,
                'default' => '',
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bigger' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bigger' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bigger' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .bigger-price-table .image-wrap' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'image_padding',
            [
                'label' => esc_html__( 'Padding', 'bigger' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}} .bigger-price-table .image-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#fff8e9',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .image-wrap' => 'background-color: {{VALUE}};',
                ],
            ]
        );

	    $this->end_controls_section();

	    $this->start_controls_section(
	        'section_price_style',
            [
                'label' => esc_html__( 'Title & Price', 'bigger' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            ]
        );

        $this->add_control(
            'price_list_alignment',
            [
                'label' => esc_html__( 'Alignment', 'bigger' ),
                'type'  => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options'  => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bigger' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bigger' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bigger' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .price-wrap' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'pricing_padding',
            [
                'label' => esc_html__( 'Padding', 'bigger' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .price-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'pricing_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#051f45',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .price-wrap' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_style',
            [
                'label' => esc_html__( 'Title', 'bigger' ),
                'type'  => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_spacing',
            [
                'label' => esc_html__( 'Spacing', 'bigger' ),
                'type'  => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 16,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .price-wrap h6' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .price-wrap h6' => 'color: {{VALUE}};',
                ],
            ]
        );



        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .bigger-price-table .price-wrap h6',
            ]
        );

        $this->add_control(
            'pricing_style',
            [
                'label' => esc_html__( 'Pricing', 'bigger' ),
                'type'  => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'pricing_spacing',
            [
                'label' => esc_html__( 'Spacing', 'bigger' ),
                'type'  => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 14,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .price-wrap p' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label'   => esc_html__( 'Color', 'bigger' ),
                'type'    => Controls_Manager::COLOR,
                'default' => '#fdba2c',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .price-wrap p .currency' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'price_typography',
                'selector' => '{{WRAPPER}} .bigger-price-table .price-wrap p .currency',
            ]
        );

        $this->add_control(
            'period_style',
            [
                'label' => esc_html__( 'Period', 'bigger' ),
                'type'  => Controls_Manager::HEADING,
                'separator' => 'after',
                'condition' => [
                    'currency_symbol!' => '',
                ],
            ]
        );

        $this->add_control(
            'period_color',
            [
                'label' => esc_html__( 'Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .price-wrap p .period' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'period_typography',
                'selector' => '{{WRAPPER}} .bigger-price-table .price-wrap p .period',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_features_list_style',
            [
                'label' => esc_html__( 'Features', 'bigger' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            ]
        );

        $this->add_responsive_control(
            'features_list_padding',
            [
                'label' => esc_html__( 'Padding', 'bigger' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'features_list_color',
            [
                'label' => esc_html__( 'Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default'	=> '#707070',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'features_list_typography',
                'selector' => '{{WRAPPER}} .bigger-price-table .features-wrap li',
            ]
        );

        $this->add_control(
            'features_list_alignment',
            [
                'label' => esc_html__( 'Alignment', 'bigger' ),
                'type'  => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options'  => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bigger' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bigger' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bigger' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap' => 'text-align: {{VALUE}}',
                ],
            ]
        );

       	$this->add_control(
            'divider_gap',
            [
                'label' => esc_html__( 'Gap', 'bigger' ),
                'type'  => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 15,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap li' => 'margin-bottom: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_button_style',
            [
                'label' => esc_html__( 'Button', 'bigger' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'show_label' => false,
                'condition' => [
                    'button_text!' => '',
                ],
            ]
        );
        $this->add_control(
            'button_list_alignment',
            [
                'label' => esc_html__( 'Alignment', 'bigger' ),
                'type'  => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options'  => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bigger' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'none' => [
                        'title' => esc_html__( 'Center', 'bigger' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bigger' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap div' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_text_padding',
            [
                'label' => esc_html__( 'Padding', 'bigger' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap a.btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'btn_margin',
            [
                'label' => esc_html__( 'Margin', 'bigger' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap a.btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'heading_footer_button',
            [
                'label' => esc_html__( 'Button', 'bigger' ),
                'type'  => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs( 'tabs_button_style' );

        $this->start_controls_tab(
            'tab_button_normal',
            [
                'label'     => esc_html__( 'Normal', 'bigger' ),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'  => 'button_typography',
                'label' => esc_html__( 'Typography', 'bigger' ),
                'selector'  => '{{WRAPPER}} .bigger-price-table .features-wrap a.btn',
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label'   => esc_html__( 'Text Color', 'bigger' ),
                'type'    => Controls_Manager::COLOR,
                'default' => '#707070',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap a.btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_color',
            [
                'label' => esc_html__( 'Background Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap a.btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(), [
                'name'  => 'button_border',
                'label' => esc_html__( 'Border', 'bigger' ),
                'placeholder' => '1px',
                'default'   => '1px',
                'selector'  => '{{WRAPPER}} .bigger-price-table .features-wrap a.btn',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bigger' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap a.btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_button_hover',
            [
                'label'     => esc_html__( 'Hover', 'bigger' ),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label' => esc_html__( 'Text Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#051f45',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap a.btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_hover_color',
            [
                'label' => esc_html__( 'Background Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#fdba2c',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap a.btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => esc_html__( 'Border Color', 'bigger' ),
                'type'  => Controls_Manager::COLOR,
                'default'   => '#fdba2c',
                'selectors' => [
                    '{{WRAPPER}} .bigger-price-table .features-wrap a.btn:hover' => 'border: 1px solid  {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

    }

    private function get_currency_symbol( $symbol_name ) {
        $symbols = [
            'dollar' => '&#36;',
            'euro'   => '&#128;',
            'franc'  => '&#8355;',
            'pound'  => '&#163;',
            'ruble'  => '&#8381;',
            'shekel' => '&#8362;',
            'baht'   => '&#3647;',
            'yen'    => '&#165;',
            'won'    => '&#8361;',
            'guilder'=> '&fnof;',
            'peso'   => '&#8369;',
            'peseta' => '&#8359',
            'lira'   => '&#8356;',
            'rupee'  => '&#8360;',
            'real'   => 'R$',
            'krona'  => 'kr',
        ];
        return isset( $symbols[ $symbol_name ] ) ? $symbols[ $symbol_name ] : '';
    }

	protected function render() {
		// get_settings() gets all data associated with the instance of this Widget (values for controls, etc)
		$settings = $this->get_settings();
        $symbol = '';

        if ( ! empty( $settings['currency_symbol'] ) ) {
            if ( 'custom' !== $settings['currency_symbol'] ) {
                $symbol = $this->get_currency_symbol( $settings['currency_symbol'] );
            } else {
                $symbol = $settings['currency_symbol_custom'];
            }
        }

        $this->add_render_attribute( 'button', 'class', [ 'btn', ] );

        if ( ! empty( $settings['link']['url'] ) ) {
            $this->add_render_attribute( 'button', 'href', $settings['link']['url'] );

            if ( ! empty( $settings['link']['is_external'] ) ) {
                $this->add_render_attribute( 'button', 'target', '_blank' );
            }
        }

        if ( ! empty( $settings['button_hover_animation'] ) ) {
            $this->add_render_attribute( 'button', 'class', 'tgx-animation-' . $settings['button_hover_animation'] );
        }
        ?>
        <div class="bigger-price-table">

        	<?php if ( ! empty( $settings['pricing_image']['url'] ) ) : ?>
            <div class="image-wrap">
                <img src="<?php echo $settings['pricing_image']['url']; ?>" alt="<?php echo $settings['title']; ?>" />
            </div><!-- .table-image -->
            <?php endif; ?>

            <div class="price-wrap">
            	<?php if ( $settings['title'] ) { ?>
                <h6><?php echo esc_attr($settings['title']); ?></h6>
                <?php } ?>
                <span>-</span>
                <p>
                <?php if ( ! empty( $symbol ) || ! empty( $settings['price'] ) ) { ?>
                    <span class="currency"><?php echo esc_attr($symbol.$settings['price']); ?></span>
                <?php } ?>
                <?php if ( ! empty( $settings['period'] ) ) { ?>
                    <span class="period"><?php echo esc_attr($settings['period']); ?></span>
                <?php } ?>
             	</p>
            </div>

            <div class="features-wrap">
	            <?php if ( ! empty( $settings['features_list'] ) ) { ?>
	            <ul class="unstyle">
	                <?php foreach ( $settings['features_list'] as $item ) : ?>
	                    <li class="features-item"><?php if( $item['item_text'] ) : echo wp_specialchars_decode($item['item_text']); endif  ?></li>
	                <?php endforeach; ?>
	            </ul>
	            <?php } if ( ! empty( $settings['button_text'] ) ){ ?>
	            	<div>
                    <a <?php echo $this->get_render_attribute_string( 'button' ); ?>>
                        <?php esc_html_e($settings['button_text'], 'bigger'); ?>
                    </a>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
	}

	protected function _content_template() {}
}
// After the Bigger_Pricing class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Pricing() );