<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Fun facts 
 */
class Bigger_Portfolio extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bportfolio';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Portfolio', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-icon-box';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'bigger' ),
			]
		);

		$this->add_control(
			'photo', [
				'label' => __( 'Project Photo', 'bigger' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'cate',
			[
				'label' => __( 'Select category', 'bigger' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' =>  $this->get_cate(),
				'label_block' => true
			]
		);
		
		$this->add_control(
			'name',
			[
				'label' => __( 'Name Project', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Type your name portfolio here', 'bigger' ),
				'default' => __('Avenger center', 'bigger'),
				'label_block' => true
			]
		);

		$this->add_control(
			'info_project',
			[
				'label' => __( 'Info Project', 'bigger' ),
				'type' => Controls_Manager::WYSIWYG,
				'placeholder' => __( 'Type your info portfolio here', 'bigger' ),
				'default' => __('', 'bigger'),
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'bigger' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'bigger' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
			]
		);

		$this->add_control(
			'position',
			[
				'label' => __( 'Image Position', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'top',
				'options' => [
					'top'  => __( 'Top', 'bigger' ),
					'bottom' => __( 'Bottom', 'bigger' ),
				],
			]
		);

		$this->add_control(
			'text_btn',
			[
				'label' => __( 'Text', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'View details', 'bigger' ),
				'placeholder' => __( 'View details', 'bigger' ),
			]
		);

		$this->end_controls_section();

	}

	private function get_cate() {
		$categories = get_terms('portfolio_cat');
		$cate_name = [];
		if( !empty($categories) ){
	        foreach( (array)$categories as $categorie){
	            $cate_name[$categorie->slug] = $categorie->name;
	        }
	    }
	    return $cate_name;
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="project-slider projects style-2">
			<?php 
				$cate_name = '';
				$link_attributes = '';
				if( $settings['cate'] ){
					foreach( $settings['cate'] as $categorie){
			            $cates = get_term_by('slug', $categorie, 'portfolio_cat');
			            $cate_name .= '<span>'.$cates->name.'</span>';
			        }
				}

				if ( ! empty( $settings['link']['url'] ) ) {
					$this->add_render_attribute( 'link', 'href', $settings['link']['url'] );
					$this->add_render_attribute( 'link', 'class', 'pagelink btn' );
					if ( $settings['link']['is_external'] ) {
						$this->add_render_attribute( 'link', 'target', '_blank' );
					}

					if ( $settings['link']['nofollow'] ) {
						$this->add_render_attribute( 'link', 'rel', 'nofollow' );
					}
				}
				$link_attributes = $this->get_render_attribute_string( 'link' );

			?>
				
            <div class="project-item">
                <div class="inner">
                	<?php if( $settings['position'] === 'top' ) { ?>
                	<div class="p-thumb">
	                    <a href="">
	                        <img src="<?php echo esc_attr( $settings['photo']['url'] ); ?>">
	                    </a>
	                </div>
                	<?php } ?>
                    <div class="item-hover <?php if( $settings['position'] === 'top' ){ echo 'bottom';}else{ echo 'top'; } ?>">
                    	<p class="p-cate"><?php echo wp_specialchars_decode($cate_name); ?></p>
                    	<div class="is-line"></div>
                    	<h4>
                            <a href=""><?php echo wp_specialchars_decode($settings['name']); ?></a>
                        </h4>
                        <?php echo wp_specialchars_decode($settings['info_project']); ?>
                        <a <?php echo $link_attributes; ?>><?php echo $settings['text_btn']; ?></a>
                    </div>
                    <?php if( $settings['position'] === 'bottom' ) { ?>
                    	<div>
                    <a href="">
                        <img src="<?php echo esc_attr( $settings['photo']['url'] ); ?>">
                    </a></div>
                	<?php } ?>
                </div>
            </div>
	    </div>
	    <?php 
	}

	protected function _content_template() {}
}
// After the Bigger_Portfolio class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Portfolio() );