<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Portfolio Slider 
 */
class Bigger_Portfolio_Slider extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-slider-portfolio';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return esc_html__( 'Bigger Portfolio Slider', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-slider-full-screen';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'bigger' ),
			]
		);

		$this->add_control(
			'column',
			[
				'label' => esc_html__( 'Columns', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'default' => '4',
				'options' => [
					'2'  => esc_html__( '2', 'bigger' ),
					'3' => esc_html__( '3', 'bigger' ),
					'4' => esc_html__( '4', 'bigger' ),
				],
			]
		);
		
		$this->add_control(
			'number',
			[
				'label' => esc_html__( 'Show Number Projects', 'bigger' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '6',
			]
		);

        $this->add_control(
			'exc',
			[
				'label' => esc_html__( 'Number Excerpt Length', 'bigger' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '16',
				'condition'		=> [
					'is_hover' 	=> 'yes'
				]
			]
		);

		$this->add_control(
			'btn',
			[
				'label' => esc_html__( 'Details Button', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'View Detail',
				'label_block' => true,
				'condition'		=> [
					'is_hover' 	=> 'yes'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'setting_section',
			[
				'label' => esc_html__( 'Setting', 'bigger' ),
				'tab' => Controls_Manager::TAB_SETTINGS,
			]
		);

		$this->add_control(
            'is_hover',
            [
                'label' => esc_html__('Hover', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'bigger'),
                'label_off' => esc_html__('No', 'bigger'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

		$this->add_control(
            'auto',
            [
                'label' => esc_html__('Autoplay', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'bigger'),
                'label_off' => esc_html__('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

        $this->add_control(
            'arrows',
            [
                'label' => esc_html__('Slide Arrows', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'bigger'),
                'label_off' => esc_html__('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

        $this->add_control(
            'dots',
            [
                'label' => esc_html__('Slide Dot', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'bigger'),
                'label_off' => esc_html__('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'false',
            ]
        );

		$this->end_controls_section();

		// Style

		$this->start_controls_section(
			'text_style_section',
			[
				'label' => esc_html__( 'Text', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_title',
			[
				'label' => esc_html__( 'Title', 'bigger' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'title_space',
			[
				'label' => esc_html__( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .project-item .inner h4' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		
		$this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__( 'Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .project-item .inner h4 a',
				
			]
		);

		$this->add_control(
			'cate_title',
			[
				'label' => esc_html__( 'Category', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
            'cate_color',
            [
                'label' => esc_html__( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'cate_typography',
				'selector' => '{{WRAPPER}} .project-item .inner h6',
				
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'image_style_section',
			[
				'label' => esc_html__( 'Image', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'img_overlay_color',
            [
                'label' => esc_html__( 'Overlay', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-overlay' => 'background-image: linear-gradient(to top, {{VALUE}}, rgba(0, 0, 0, 0));',
                ],
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'hover_style_section',
			[
				'label' => esc_html__( 'Item Hover', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'		=> [
					'is_hover' 	=> 'yes'
				]
			]
		);

		$this->add_control(
			'overlay_title',
			[
				'label' => esc_html__( 'Overlay', 'bigger' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
            'overlay_color',
            [
                'label' => esc_html__( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner.is-hover:hover .item-hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
			'exc_title',
			[
				'label' => esc_html__( 'Excerpt', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'exc_space',
			[
				'label' => esc_html__( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .project-item .inner .item-hover h6' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .project-item .inner .item-hover p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
            'exc_color',
            [
                'label' => esc_html__( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner .item-hover p' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'exc_typography',
				'selector' => '{{WRAPPER}} .project-item .inner .item-hover p',
			]
		);

        $this->add_control(
			'heading_btn',
			[
				'label' => esc_html__( 'Detail Button', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagelink.gray' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_color_hover',
            [
                'label' => esc_html__( 'Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagelink.gray:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .pagelink.gray',
				
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'navigation_section',
			[
				'label' => __( 'Navigation', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'arrow_style',
			[
				'label' => __( 'Arrow', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'condition' => [
					'arrows' => 'true'
				]
			]
		);

		$this->add_control(
            'arrow_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-slider .slick-arrow' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );


		$this->add_control(
            'arrow_color_hover',
            [
                'label' => __( 'Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-slider .slick-arrow:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
            'bg_arrow_color',
            [
                'label' => __( 'Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-slider .slick-arrow' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
            'arrow_bg_color_hover',
            [
                'label' => __( 'Hover Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-slider .slick-arrow:hover' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
			'dot_style',
			[
				'label' => __( 'Dot', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'dots' => 'true'
				]
			]
		);

		$this->add_control(
            'dot_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'dots' => 'true'
				]
            ]
        );

        $this->add_control(
            'dot_color_active',
            [
                'label' => __( 'Color Active', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li.slick-active button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'dots' => 'true'
				]
            ]
        );

        $this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$has_icon = ! empty( $settings['type_icon'] ) && 'none' !== $settings['type_icon'];
		?>
		<div class="project-slider-wraper">
			<div class="project-slider projects" data-show="<?php echo esc_attr( $settings['column'] ); ?>" data-arrow="<?php echo esc_attr( $settings['arrows'] ); ?>" data-dots="<?php echo esc_attr( $settings['dots'] ); ?>" data-auto="<?php echo esc_attr( $settings['auto'] ); ?>">
	            <?php
	            
	                $args = array(
	                    'post_type' => 'ot_portfolio',
	                    'posts_per_page' => $settings['number']
	                );
	            	$wp_query = new \WP_Query($args);
	            	while ($wp_query -> have_posts()) : $wp_query -> the_post();
		                $cates = get_the_terms(get_the_ID(),'portfolio_cat');
		                $cate_name ='';
		                $cate_slug = '';
		            	foreach((array)$cates as $cate){
		                    if(count($cates)>0){
		                        $cate_name .= $cate->name.'<span>, </span>';
		                        $cate_slug .= $cate->slug .' ';
		                    }
		                }
	            ?>
	                <div>
		                <div class="project-item <?php echo esc_attr($cate_slug); ?>">
		                    <div class="inner <?php if( $settings['is_hover'] ) echo 'is-hover';?>">
	                            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?><div class="item-overlay"></div></a>
		                        <div class="title-cat">
		                        	<h4 class="text-light">
		                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> 
		                            </h4>
		                            <h6><?php echo wp_specialchars_decode($cate_name); ?></h6>
		                        </div>
		                        <div class="item-hover">
		                        	<h4 class="text-light">
		                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> 
		                            </h4>
		                            <h6><?php echo wp_specialchars_decode($cate_name); ?></h6>
	                            	<?php if( $settings['exc'] ) { echo wp_specialchars_decode('<p>'.bigger_excerpt_length( $settings['exc'] ).'</p>'); }?>
	                            	<a class="pagelink gray" href="<?php the_permalink(); ?>"><?php echo $settings['btn']; ?></a>
		                        </div>
		                    </div>
		                </div>
	                </div>
	            <?php endwhile; wp_reset_postdata(); ?>
		    </div>
	    </div>
	    <?php
	}

	protected function _content_template() {}
}
// After the Bigger_Portfolio_Slider class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Portfolio_Slider() );