<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Fun facts 
 */
class Bigger_Portfolio_Filter extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-portfolio-filter';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Portfolio Filter', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-icon-box';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'bigger' ),
			]
		);

    	$this->add_control(
			'idcate_project',
			[
				'label' => __( 'Select Categories', 'bigger' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $this->select_param_cate_project(),
				'multiple' => true,
				'label_block' => true,
			]
		);

    	$this->add_control( 
			'style', 
			[
	            'type'         => Controls_Manager::SELECT,
	            'label'        => __( 'Style', 'bigger' ),
	            'default'      => 'style-2',
	            'options'      => [
		            'style-1' => __( 'Style 1: Title Under', 'bigger' ),
		            'style-2' => __( 'Style 2: Title Inner', 'bigger' ),
		        ],
	        ] 
    	);

    	$this->add_control(
			'number',
			[
				'label' => __( 'Show Number Item', 'bigger' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '6',
			]
		);

		$this->add_control(
			'exc',
			[
				'label' => esc_html__( 'Number Excerpt Length', 'bigger' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '16',
				'condition'		=> [
					'style' 	=> 'style-1'
				],
			]
		);

		$this->add_control(
			'column',
			[
				'label' => __( 'Columns', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'2'  => __( '2', 'bigger' ),
					'3' => __( '3', 'bigger' ),
					'4' => __( '4', 'bigger' ),
				],
			]
		);

		$this->add_control(
			'filter',
			[
				'label' => __( 'Show Filter', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'show',
				'options' => [
					'show'  => __( 'Show', 'bigger' ),
					'hide' => __( 'Hidden', 'bigger' ),
				],
			]
		);

		$this->add_control(
			'all',
			[
				'label' => __( 'Show All Text Projects', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'All',
				'condition' => [
					'filter' => 'show',
				],
			]
		);

		$this->add_control(
            'big_thumb',
            [
                'label' => __('Show Big Thumbnail', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bigger'),
                'label_off' => __('Hidden', 'bigger'),
                'return_value' => 'yes',
                'default' => '',
                'condition'		=> [
                	'style'		=> 'style-2'
                ]
            ]
        );

		$this->end_controls_section();

		// Icon
		$this->start_controls_section(
			'btn_section',
			[
				'label' => __( 'Button', 'bigger' ),
				'condition' => [
					'style!' => 'style-2'
				]
			]
		);

		$this->add_control(
			'text_btn',
			[
				'label' => __( 'Details Button', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'bigger' ),
				'placeholder' => __( 'Click here', 'bigger' ),
			]
		);


		$this->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'elementor' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-link',
					'library' => 'fa-solid',
				],
			]
		);

		$this->end_controls_section();

		// Style
		$this->start_controls_section(
			'text_style_section',
			[
				'label' => __( 'Content', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_img',
			[
				'label' => __( 'Image', 'bigger' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'img_space',
			[
				'label' => esc_html__( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .project-item .inner img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'style!' => 'style-2'
				]
			]
		);

		$this->add_control(
            'img_overlay_color',
            [
                'label' => __( 'Overlay', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-overlay' => 'background-image: linear-gradient(to top, {{VALUE}}, rgba(0, 0, 0, 0));',
                ],
                'condition' => [
					'style!' => 'style-1'
				]
            ]
        );

		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'title_space',
			[
				'label' => esc_html__( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .project-item .title-cat h4, {{WRAPPER}} .project-item .box-content h4' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .title-cat h4 a, {{WRAPPER}} .project-item .box-content h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => __( 'Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .project-item .title-cat h4 a:hover, {{WRAPPER}} .project-item .box-content h4 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .project-item .title-cat h4 a, {{WRAPPER}} .project-item .box-content h4 a',
			]
		);

        $this->add_control(
			'heading_cat',
			[
				'label' => __( 'Category', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'style!' => 'style-1'
				]
			]
		);

		$this->add_control(
            'cat_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner h6' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'style!' => 'style-1'
				]
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'cat_typography',
				'selector' => '{{WRAPPER}} .project-item .inner h6',
				'condition' => [
					'style!' => 'style-1'
				]
			]
		);

        $this->add_control(
			'heading_exc',
			[
				'label' => __( 'Excerpt', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'style!' => 'style-2'
				]
			]
		);

		$this->add_responsive_control(
			'desc_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .project-item .inner .box-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'style!' => 'style-2'
				]
			]
		);

		$this->add_control(
            'desc_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner .box-content p' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'style!' => 'style-2'
				]
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'selector' => '{{WRAPPER}} .project-item .inner .box-content p',
				'condition' => [
					'style!' => 'style-2'
				]
			]
		);

        $this->add_control(
			'heading_btn',
			[
				'label' => __( 'Detail Button', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'style!' => 'style-2'
				]
			]
		);

		$this->add_responsive_control(
			'icon_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .project-item .inner .box-content i' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
				'condition'	=> [
					'selected_icon[value]!'	=> '',
					'style!' => 'style-2'
				],
			]
		);

        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner .viewpage i, {{WRAPPER}} .box-content .pagelink' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'style!' => 'style-2'
				]
            ]
        );

        $this->add_control(
            'btn_color_hover',
            [
                'label' => __( 'Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner .viewpage:hover i,
                    {{WRAPPER}} .box-content .pagelink:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'style!' => 'style-2'
				]
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .box-content .pagelink',
				'condition' => [
					'style!' => 'style-2'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'filter_style_section',
			[
				'label' => __( 'Filter', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'filter_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .cat-filter' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
            'filter_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cat-filter a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_color_active',
            [
                'label' => __( 'Active', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cat-filter a.selected' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'filter_typography',
				'selector' => '{{WRAPPER}} .cat-filter a',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( ! isset( $settings['icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['icon'] = 'fa fa-star';
		}
		$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
		$is_new = ! isset( $settings['icon'] ) && Icons_Manager::is_migration_allowed();
		?>
		<div class="project-filter" data-column="<?php echo esc_attr($settings['column']); ?>">
			<?php if( $settings['filter'] ==='show' ){ ?>
        	<div class="cat-filter" id="filters">
                <?php if( $settings['all'] ){ ?><a href="#" data-filter="*" class="filter-item all-cat selected"><?php echo esc_html( $settings['all'] ); ?></a><?php } ?>

                <?php if( $settings['idcate_project'] ){ 

                	$categories = $settings['idcate_project'];
                	foreach( (array)$categories as $categorie){
                        $cates = get_term_by('slug', $categorie, 'portfolio_cat');
                        $cat_name = $cates->name;
                        $cat_slug = $cates->slug;
                ?>

                <a href="#" data-filter=".<?php echo esc_attr( $cat_slug ); ?>" class="filter-item"><?php echo esc_html( $cat_name ); ?></a>

            	<?php } }else{
	                $categories = get_terms('portfolio_cat');
                    foreach( (array)$categories as $categorie){
                        $cat_name = $categorie->name;
                        $cat_slug = $categorie->slug;

                ?>
                <a href="#" data-filter=".<?php echo esc_attr( $cat_slug ); ?>" class="filter-item"><?php echo esc_html( $cat_name ); ?></a>
                
            	<?php } } ?>
            </div>
        	<?php } ?>

	        <div id="projects" class="projects row">
	            <?php

            	if( $settings['idcate_project'] ){
	                $args = array(
	                    'posts_per_page' => $settings['number'],
	                    'post_type' => 'ot_portfolio',
	                    'tax_query' => array(
	                        array(
	                            'taxonomy' => 'portfolio_cat',
	                            'field' => 'slug',
	                            'terms' => $settings['idcate_project'],
	                        ),
	                    ),              
	                );
	            }else{
	                $args = array(
	                    'post_type' => 'ot_portfolio',
	                    'posts_per_page' => $settings['number']
	                );
	            }
	            $wp_query = new \WP_Query($args);
	            while ($wp_query -> have_posts()) : $wp_query -> the_post();
	                $cates = get_the_terms(get_the_ID(),'portfolio_cat');
	                $cate_name ='';
	                $cate_slug = '';
	                foreach((array)$cates as $cate){
	                    if(count($cates)>0){
	                        $cate_name .= $cate->name .'<span>, </span>';
	                        $cate_slug .= $cate->slug .' ';
	                    }
	                }
	                $img = $column = $big_column = '';
	                
	                if( function_exists( 'rwmb_meta' ) ) {
	                    $images = rwmb_meta( 'big_image', "type=image" );
	                    
	                    if( $settings['column'] == 3 ){
	                        if( $images ){
	                            $big_column = 'col-md-8 col-sm-12 big-thumb';
	                            $column = 'col-md-4 col-sm-6';
	                        }else{
	                            $big_column = $column = 'col-md-4 col-sm-6';
	                        }
	                    }elseif( $settings['column'] == 2 ){
	                        if( $images ){
	                            $big_column = 'col-md-12 col-sm-12 big-thumb';
	                            $column = 'col-md-6 col-sm-6';
	                        }else{
	                            $big_column = $column = 'col-md-6 col-sm-6';
	                        }
	                    }else{
	                        if( $images ){
	                            $big_column = 'col-md-6 col-sm-6 big-thumb';
	                            $column = 'col-md-3 col-sm-6';
	                        }else{
	                            $big_column = $column = 'col-md-3 col-sm-6';
	                        }
	                    }
	                }
	                ?>
	                <div class="project-item <?php echo esc_attr($cate_slug); if( $settings['big_thumb'] && $images ) { echo esc_attr( $big_column ); }else{ echo esc_attr( $column ); } ?>">
	                    <div class="inner">
	                    	
	                        <?php if( $settings['style'] == 'style-1' ){ ?>
	                        	<div class="box-content">
		                        <?php if ( has_post_thumbnail() ) : ?>
	                        		<div class="content-img">
		                        		<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a> 
		                        	</div>
		                        <?php endif; ?>
	                        	
	                        		<h4>
	                        			<a href="<?php the_permalink(); ?>"><?php  the_title(); ?></a>
	                        		</h4>
	                        		<?php if( $settings['exc'] ) { echo wp_specialchars_decode('<p>'.bigger_excerpt_length( $settings['exc'] ).'</p>'); }?>
	                        		<?php if( $settings['text_btn'] ) : ?>
									<div class="viewpage">
			                            <?php
										if ( $is_new || $migrated ) {
											Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
										} elseif ( ! empty( $settings['icon'] ) ) { ?>
											<i class="<?php echo esc_attr( $settings['icon'] ) ?>" aria-hidden="true"></i>
										<?php } ?>
			                            <a class="pagelink" href="<?php the_permalink(); ?>"><?php echo $settings['text_btn']; ?></a>
			                        </div>
									<?php endif; ?>
	                        	</div>

	                        <?php }else{ ?>
								<?php if( $settings['big_thumb'] && $images ){ foreach ( $images as $image ) {  
		                        	$img = $image['full_url']; 
		                        ?>
									
			                        <a href="<?php the_permalink(); ?>">
			                        	<img class="" src="<?php echo esc_url($img); ?>" alt="<?php the_title(); ?>">
			                        	<div class="item-overlay"></div>
			                        </a>

								<?php } }else{ if ( has_post_thumbnail() ) { ?>

		                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?><div class="item-overlay"></div></a> 

		                        <?php } } ?>

		                        <div class="title-cat">
		                        	<h4 class="text-light">
		                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
		                            </h4>
		                            <h6><?php echo wp_specialchars_decode($cate_name); ?></h6>
		                        </div>

	                    	<?php } ?>
	                    </div>
	                </div>
	            <?php endwhile; wp_reset_postdata(); ?>
	        </div>
	    </div>
	    <?php
	}

	protected function _content_template() {}

	protected function select_param_cate_project() {
	  	$category = get_terms( 'portfolio_cat' );
	  	$cat = array();
	  	foreach( $category as $item ) {
	     	if( $item ) {
	        	$cat[$item->slug] = $item->name;
	     	}
	  	}
	  	return $cat;
	}
}
// After the Bigger_Portfolio_Filter class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Portfolio_Filter() );