<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: News Slider
 */
class Bigger_News_Slider extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-news-slider';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger News Slider', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-post-slider';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'bigger' ),
			]
		);

		$this->add_control(
			'idpost',
			[
				'label' => __( 'News List', 'bigger' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $this->select_param_news(),
				'multiple' => true,
				'label_block' => true
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'setting_section',
			[
				'label' => __( 'Setting', 'bigger' ),
				'tab' => Controls_Manager::TAB_SETTINGS,
			]
		);

		$this->add_control(
			'number',
			[
				'label' => __( 'Slide To Show', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'2' => __( '2', 'bigger' ),
					'3' => __( '3', 'bigger' ),
					'1' => __( '1', 'bigger' ),
				],
			]
		);

		$this->add_control(
            'auto',
            [
                'label' => __('Autoplay ?', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bigger'),
                'label_off' => __('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

        $this->add_control(
			'arrows',
			[
				'label' => __( 'Arrows Slide ?', 'bigger' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'bigger' ),
				'label_off' => __( 'Hide', 'bigger' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);

		$this->add_control(
			'dots',
			[
				'label' => __( 'Dots Slide ?', 'bigger' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'bigger' ),
				'label_off' => __( 'Hide', 'bigger' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);

		$this->add_control(
            'display_line',
            [
                'label' => __('Display Line', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bigger'),
                'label_off' => __('Hidden', 'bigger'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition'	=>[
                	'display_meta!'	=> ''
                ]
            ]
        );

        $this->add_control(
            'display_meta',
            [
                'label' => __('Display Meta ?', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bigger'),
                'label_off' => __('Hidden', 'bigger'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'image_style_section',
			[
				'label' => esc_html__( 'Image', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'img_overlay_color',
            [
                'label' => esc_html__( 'Overlay', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-overlay' => 'background-image: linear-gradient(to top, {{VALUE}}, rgba(0, 0, 0, 0));',
                ],
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'news_slider_style_section',
			[
				'label' => __( 'Title News', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'spacing_title',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .entry-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'title_news_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .news-slider .entry-title a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_news_color_hover',
			[
				'label' => __( 'Hover', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .news-slider .entry-title a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_news_typography',
				'selector' => '{{WRAPPER}} .news-slider .entry-title a',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'navigation_section',
			[
				'label' => __( 'Navigation', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'arrow_style',
			[
				'label' => __( 'Arrow', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'condition' => [
					'arrows' => 'true'
				]
			]
		);

		$this->add_control(
            'arrow_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .news-slider .slick-arrow' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
            'arrow_color_hover',
            [
                'label' => __( 'Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .news-slider .slick-arrow:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
            'bg_arrow_color',
            [
                'label' => __( 'Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .news-slider .slick-arrow' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
            'arrow_bg_color_hover',
            [
                'label' => __( 'Hover Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .news-slider .slick-arrow:hover' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
			'dot_style',
			[
				'label' => __( 'Dot', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'dots' => 'true'
				]
			]
		);

		$this->add_control(
            'dot_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'dots' => 'true'
				]
            ]
        );

        $this->add_control(
            'dot_color_active',
            [
                'label' => __( 'Color Active', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li.slick-active button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'dots' => 'true'
				]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'line_section',
			[
				'label' => __( 'Line', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'display_line'	=> 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'spacing_line',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .is-line' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'line_width',
			[
				'label' => __( 'Line Width', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 400,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .is-line' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'line_height',
			[
				'label' => __( 'Line Height', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .is-line' => 'height: {{SIZE}}{{UNIT}};',
				],
			]

		);

		$this->add_control(
            'line_color',
            [
                'label' => __( 'Line Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#b7b7b7',
                'selectors' => [
                    '{{WRAPPER}} .is-line' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'post_meta_style_section',
			[
				'label' => __( 'Post Meta', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'	=> [
                	'display_meta'	=> 'yes'
                ]
			]
		);

		$this->add_responsive_control(
			'spacing_meta',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .meta-post' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
            'post_meta_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .meta-post span a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_meta_typography',
				'selector' => '{{WRAPPER}} .meta-post span a',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="news-slider-wraper">
		<div class="news-slider" data-show="<?php echo esc_attr($settings['number']); ?>" data-auto="<?php echo esc_attr($settings['auto']); ?>" data-dots="<?php echo esc_attr($settings['dots']); ?>" data-arrow="<?php echo esc_attr($settings['arrows']); ?>">
        	<?php

	        $args = array(
	            'post_type' => 'post',
	            'posts_per_page' => -1,
	            'post__in' => $settings['idpost']
	        );
	        $blogpost = new \WP_Query($args);
	        if($blogpost->have_posts()) : while($blogpost->have_posts()) : $blogpost->the_post();
	            $format = get_post_format();
	        ?>
	            <div>
	                <article class="news-item content-area">
	                    <div class="inner-item">
	                        <?php if ( has_post_thumbnail() ) : ?>
                            <div class="thumb-image">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail(); ?>
                                    <div class="item-overlay"></div>
                                </a>
                            </div> 
	                        <?php endif; ?>
	                        <div class="inner-post">
	                            <h4 class="entry-title text-light">
	                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
	                            </h4>
	                            <?php if( $settings['display_meta'] ){ ?>
	                            <div class="meta-post">
	                            	<?php if( $settings['display_line'] ){ ?><div class="is-line"></div><?php } ?>
	                            	<?php bigger_post_meta(); ?>
	                            </div>
	                            <?php } ?>
	                        </div>
	                    </div>
	                </article>
	            </div>
	        <?php endwhile; wp_reset_postdata(); endif; ?>
	    </div>
	    </div>
		<?php 
		
	}

	protected function _content_template() {}

	protected function select_param_news() {
	    $args = array(
	        'numberposts' => -1, // 'numberposts' and 'posts_per_page' can be used interchangeably.
	        'post_type'   => 'post'
	    );
	    $posts = get_posts( $args );
	    $cat = array();
	    foreach( $posts as $post ) {
	        if( $post ) {
	            $cat[$post->ID] = $post->post_title;
	        }
	    }
	    return $cat;
	}
}
// After the Bigger_News_Slider class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_News_Slider() );