<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Fun facts 
 */
class Bigger_Member_Team extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-member-team';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Member Team', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-person';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Member Content', 'bigger' ),
			]
		);

		$this->add_control(
	       'team_image',
	        [
	           'label' => esc_html__( 'Member Image', 'bigger' ),
	           'type'  => Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri() . '/images/team1.jpg',
			  	],
	     	]
	    );

	    $this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'default' => 'full',
				'separator' => 'none',
			]
		);

	    $this->add_control(
		    'team_name',
		      	[
		          'label' => esc_html__( 'Member Name', 'bigger' ),
		          'type'  => Controls_Manager::TEXTAREA,
		          'default' => esc_html__( 'Jonathan Morgan', 'bigger' ),
		    	]
	    );

	   	$this->add_control(
		    'job',
		      	[
		          'label' => esc_html__( 'Member Job', 'bigger' ),
		          'type'  => Controls_Manager::TEXTAREA,
		          'default' => esc_html__( 'Graphics Designer', 'bigger' ),
		      	]
		);

		$this->add_control(
            'is_hover',
            [
                'label' => __('Is Hover?', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bigger'),
                'label_off' => __('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

			$repeater = new Repeater();

			    $repeater->add_control(
			      	'title',
			      	[
			          	'label'   => esc_html__( 'Social Name', 'bigger' ),
			          	'type'    => Controls_Manager::TEXT,
			          	'default' => esc_html__( 'Facebook', 'bigger' ),
			      	]
			    );


				$repeater->add_control(
		            'social_link',
		            [
		                'label' => esc_html__( 'Social Link', 'bigger' ),
		                'type'  => Controls_Manager::URL,
		                'dynamic' => [
							'active' => true,
						],
						'placeholder' => __( 'https://www.facebook.com/bigger', 'bigger' ),
						'default' => [
							'url' => 'https://www.facebook.com/bigger', 
						],
		            ]
		        );

		        $repeater->add_control(
		            'social_icon',
		            [
		                'label' => esc_html__( 'Social Icon', 'bigger' ),
		                'type'  => Controls_Manager::ICONS,
		                'fa4compatibility' => 'social',
		                'label_block' => true,
		                'default' => [
	                		'value'	=> 'fab fa-facebook',
	                		'library' => 'fa-brands',
	                	],
		            ]
		        );


			$this->add_control(
			    'social_share',
		      	[
		          	'label'       => esc_html__( 'Social Share', 'bigger' ),
		          	'type'        => Controls_Manager::REPEATER,
		          	'show_label'  => true,
		          	'default'     => [
		              	[
		              		'title'       => esc_html__( 'Facebook', 'bigger' ),
		                	'social_link' => esc_html__( 'https://www.facebook.com/bigger', 'bigger' ),
		                	'social_icon' => [
		                		'value'	=> 'fab fa-facebook',
		                		'library' => 'fa-brands',
		                	],
		              	],
		              	[
		              		'title'       => esc_html__( 'Twitter', 'bigger' ),
		                	'social_link' => esc_html__( 'https://www.twitter.com/bigger', 'bigger' ),
		                	'social_icon' => [
		                		'value'	=> 'fab fa-twitter',
		                		'library' => 'fa-brands',
		                	],
		              	],
		              	[
		              		'title'       => esc_html__( 'Linkedin', 'bigger' ),
		                	'social_link' => esc_html__( 'https://www.linkedin.com/bigger', 'bigger' ),
		                	'social_icon' => [
		                		'value'	=> 'fab fa-linkedin',
		                		'library' => 'fa-brands',
		                	],
		              	]
		          	],
		          	'fields'      => array_values( $repeater->get_controls() ),
		          	'title_field' => '{{{title}}}',
		          	'condition'	  => [
		          		'is_hover'	=> 'true'
		          	]
		      	]
		  	);

		$this->end_controls_section();


		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__( 'Info', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'team_align',
			[
				'label'     => esc_html__( 'Info Alignment', 'bigger' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'left',
				'options'   => [
					'left'     => esc_html__( 'Left', 'bigger' ),
					'center'   => esc_html__( 'Center', 'bigger' ),
					'right'    => esc_html__( 'Right', 'bigger' ),
				],
				'selectors' => [
					'{{WRAPPER}} .member-item .member-info' => 'text-align: {{VALUE}};'
				],
			]
		);

		$this->add_control(
			'info_bg_color',
			[
				'label'     => esc_html__( 'Info Background Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .member-item .member-info' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		

		$this->add_responsive_control(
			'title_space',
			[
				'label' => esc_html__( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => -10,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .member-item .member-info h6' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .member-item .member-info h6' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name'     => 'title_typography',
					'label'    => esc_html__( 'Typography', 'bigger' ),
					'selector' => '{{WRAPPER}} .member-item .member-info h6',
				]
		);

		$this->add_control(
			'heading_job',
			[
				'label' => __( 'Job', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'job_color',
			[
				'label'     => esc_html__( 'Job Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .member-item .member-info p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name'     => 'job_typography',
					'label'    => esc_html__( 'Typography', 'bigger' ),
					'selector' => '{{WRAPPER}} .member-item .member-info p',
				]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'icon_style',
			[
				'label' => esc_html__( 'Social Icon', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'	  => [
	          		'is_hover'	=> 'true'
	          	]
			]
		);

		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Font Size', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 12,
						'max' => 30,
					],
				],
				'selectors' => [
					'{{WRAPPER}}  .member-item .avatar .social-mem a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_space',
			[
				'label' => esc_html__( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => -5,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .member-item .avatar .social-mem a' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
            'border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bigger' ),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .member-item .avatar .social-mem a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


		$this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .member-item .avatar .social-mem a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .member-item .avatar .social-mem a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_hover_color',
			[
				'label'     => esc_html__( 'Hover', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fdba2c',
				'selectors' => [
					'{{WRAPPER}} .member-item .avatar .social-mem a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_hover_bg_color',
			[
				'label'     => esc_html__( 'Hover Background Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .member-item .avatar .social-mem a:hover' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'overlay_color',
			[
				'label'     => esc_html__( 'Overlay Color', 'bigger' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#051f45',
				'selectors' => [
					'{{WRAPPER}} .overlay' => 'background: {{VALUE}};',
				],
			]
		);

	$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( ! empty( $settings['team_image']['url'] ) ) {
			$this->add_render_attribute( 'team_image', 'src', $settings['team_image']['url'] );
			$this->add_render_attribute( 'team_image', 'alt', Control_Media::get_image_alt( $settings['team_image'] ) );
			$this->add_render_attribute( 'team_image', 'title', Control_Media::get_image_title( $settings['team_image'] ) );
			if( $settings['is_hover'] ){ 
				$this->add_render_attribute( 'team_image', 'class', 'is-hover' );
			}
			$image_html = Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'team_image' );
			if ( ! empty( $settings['link']['url'] ) ) {
				$image_html = '<a ' . $this->get_render_attribute_string( 'link' ) . '>' . $image_html . '</a>';
			}
		}
		$migration_allowed = Icons_Manager::is_migration_allowed();
		?>
		<div class="member-item <?php if( $settings['is_hover'] ){ echo 'is-hover'; } ?>">
			<div class="avatar">
				<?php echo wp_specialchars_decode( $image_html ); ?>
				<?php if( $settings['is_hover'] ){ ?>
				<span class="overlay"></span>
				<?php if ( ! empty( $settings['social_share'] ) ) { ?>
					<div class="social-mem">
						<?php foreach ( $settings['social_share'] as $social ) : 
							$migrated = isset( $social['__fa4_migrated']['social_icon'] );
							$is_new = empty( $social['social'] ) && $migration_allowed;
						?>
                            <?php if ( ! empty( $social['social_link'] ) ) : ?>
	                    		<a href="<?php echo $social['social_link']['url'];?>" class="<?php  echo strtolower($social['title']);?>" 
	                    			<?php if($social['social_link'] ['is_external'])
                                    { echo 'target="_blank"'; }else{ echo 'rel="nofollow"';}?>>
                                    <?php
                                    if( $is_new || $migrated ){
										Icons_Manager::render_icon( $social['social_icon'] );
									} else { ?>
										<i class="<?php echo esc_attr( $social['social'] ) ?>" aria-hidden="true"></i><?php
									}
									?>
                                </a>
	                    	<?php endif; ?>
                        <?php endforeach; ?>
	                </div>
                <?php } } ?>
			</div>
			<div class="member-info">
				<?php if ( !empty( $settings['team_name'] ) ) { ?><h6><?php echo $settings['team_name'];?></h6><?php } ?>
				<?php if ( ! empty( $settings['job'] ) ) { ?><p><?php echo $settings['job'];?></p><?php } ?>
			</div>
		</div>
		<?php
	}

	protected function _content_template() {}
}
// After the Bigger_Member_Team class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Member_Team() );