<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: List Service
 */
class Bigger_List_Service extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-list-service';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger List Service', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-cogs';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'bigger' ),
			]
		);

		$this->add_control(
			'idservice',
			[
				'label' => __( 'Select Service', 'bigger' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $this->select_param_service(),
				'multiple' => true,
				'label_block' => true,
			]
		);

		$this->add_control(
			'column',
			[
				'label' => __( 'Columns', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'2'  => __( '2', 'bigger' ),
					'3' => __( '3', 'bigger' ),
					'4' => __( '4', 'bigger' ),
				],
			]
		);

		$this->add_control(
			'exc',
			[
				'label' => __( 'Number Excerpt Length', 'bigger' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '16',
			]
		);

		$this->add_control(
			'text_btn',
			[
				'label' => __( 'Details Button', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'bigger' ),
				'placeholder' => __( 'Click here', 'bigger' ),
			]
		);

		$this->end_controls_section();

		// Style
		$this->start_controls_section(
			'image_style_section',
			[
				'label' => __( 'Image', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'image_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .box-content .content-img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'width',
			[
				'label' => __( 'Width', 'bigger' ) . ' (%)',
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
				],
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .service-box img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'text_style_section',
			[
				'label' => __( 'Text', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'bigger' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'title_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .box-content h4' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .box-content h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
			'title_color_hover',
			[
				'label' => __( 'Hover', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .box-content h4 a:hover' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .box-content h4',
				
			]
		);

        $this->add_control(
			'heading_exc',
			[
				'label' => __( 'Excerpt', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'exc_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .service-box p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
            'exc_color',
            [
                'label' => __( 'Excerpt Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-box p' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'exc_typography',
				'selector' => '{{WRAPPER}} .service-box p',
				
			]
		);

        $this->add_control(
			'heading_btn',
			[
				'label' => __( 'Detail Button', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Button Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagelink' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_color_hover',
            [
                'label' => __( 'Button Color Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagelink:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .pagelink',
				
			]
		);

		$this->end_controls_section();



	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$column = '';
        if( $settings['column'] == 3 ){
            $column = 'col-md-4 col-sm-6';
        }elseif( $settings['column'] == 2 ){
            $column = 'col-md-6 col-sm-6';
        }else{
            $column = 'col-md-3 col-sm-6'; 
        }
		?>
		
		<div class="service service-grid row">
            <?php
            $args = array(
	            'post_type' => 'ot_service',
	            'posts_per_page' => -1,
	            'post__in' => $settings['idservice']
	        );
            $wp_query = new \WP_Query($args);
            while ($wp_query -> have_posts()) : $wp_query -> the_post();?>
                <div class="service-box <?php echo esc_attr( $column ); ?>">
                    
			       	<div class="box-content">
			       		<div class="content-img"><a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a></div>
						<h4><a href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a></h4>
						<?php if( $settings['exc'] ) { echo wp_specialchars_decode('<p>'.bigger_excerpt_length( $settings['exc'] ).'</p>'); }?>
						<?php if( $settings['text_btn'] ) : ?>
							<a href="<?php the_permalink(); ?>" class="pagelink"><?php echo $settings['text_btn']; ?></a>
						<?php endif; ?>
					</div>
			    </div>
            <?php endwhile; wp_reset_postdata(); ?>
        </div>
	    <?php
	}

	protected function _content_template() {}

	protected function select_param_cate_service() {
	  	$category = get_terms( 'service_cat' );
	  	$cat = array();
	  	foreach( $category as $item ) {
	     	if( $item ) {
	        	$cat[$item->slug] = $item->name;
	     	}
	  	}
	  	return $cat;
	}

	protected function select_param_service() {
	    $args = array(
	        'numberposts' => -1, // 'numberposts' and 'posts_per_page' can be used interchangeably.
	        'post_type'   => 'ot_service'
	    );
	    $posts = get_posts( $args );
	    $data = array();
	    foreach( $posts as $post ) {
	        if( $post ) {
	            $data[$post->ID] = $post->post_title;
	        }
	    }
	    return $data;
	}
}
// After the Bigger_List_Service class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_List_Service() );