<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Latest News 
 */
class Bigger_Latest_News extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-latest-news';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Latest News', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-post-slider';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'bigger' ),
			]
		);
		 
		$this->add_control(
			'btn', [
				'label' => __( 'Details Button', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Read More' , 'bigger' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'exc',
			[
				'label' => __( 'Number Excerpt Length', 'bigger' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '16',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'latest_news_style_section',
			[
				'label' => __( 'Latest News', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_latestnews',
			[
				'label' => __( 'Title News', 'bigger' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'spacing_title',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .entry-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_latestnews_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .latest-news .entry-title a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_latestnews_color_hover',
			[
				'label' => __( 'Hover', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .latest-news .entry-title a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_latestnews_typography',
				'selector' => '{{WRAPPER}} .latest-news .entry-title a',
			]
		);

		$this->add_control(
			'heading_excerpt',
			[
				'label' => __( 'Excerpt / Summary', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'condition'	=> [
					'exc!' => ''
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'spacing_exc',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .latest-news p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition'	=> [
					'exc!' => ''
				],
			]
		);

		$this->add_control(
			'exc_latestnews_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .latest-news p' => 'color: {{VALUE}};',
				],
				'condition'	=> [
					'exc!' => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'exc_latestnews_typography',
				'selector' => '{{WRAPPER}} .latest-news p',
				'condition'	=> [
					'exc!' => ''
				]
			]
		);

		$this->add_control(
			'btn_latest_news',
			[
				'label' => __( 'Button', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'spacing_btn',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .latest-news .pagelink' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'btn_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .pagelink' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_color_hover',
			[
				'label' => __( 'Hover', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .pagelink:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .pagelink',
			]
		);

		$this->add_control(
			'heading_line',
			[
				'label' => __( 'Line', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition'	=> [
                	'display_meta'	=> 'yes'
                ]
			]
		);

		$this->add_control(
            'display_line',
            [
                'label' => __('Display ?', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bigger'),
                'label_off' => __('Hidden', 'bigger'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition'	=> [
                	'display_meta'	=> 'yes'
                ]
            ]
        );

        $this->add_control(
			'line_width',
			[
				'label' => __( 'Line Width', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 485,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .is-line' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition'	=> [
                	'display_line' => 'yes',
                	'display_meta'	=> 'yes'
                ]
			]
		);

		$this->add_control(
			'line_height',
			[
				'label' => __( 'Line Height', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 1,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .is-line' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition'	=> [
                	'display_line' => 'yes',
                	'display_meta'	=> 'yes'
                ]
			]

		);

		$this->add_control(
            'line_color',
            [
                'label' => __( 'Line Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .is-line' => 'background-color: {{VALUE}};',
                ],
                'condition'	=> [
                	'display_line' => 'yes',
                	'display_meta'	=> 'yes'
                ]
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'post_meta_style_section',
			[
				'label' => __( 'Post Meta', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'display_meta',
            [
                'label' => __('Display ?', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'bigger'),
                'label_off' => __('Hidden', 'bigger'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_responsive_control(
			'spacing_meta',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type'  => Controls_Manager::SLIDER,
				'default'  => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .latest-news .is-bottom' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition'	=> [
                	'display_meta'	=> 'yes'
                ]
			]
		);

		$this->add_control(
            'post_meta_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .meta-post span a' => 'color: {{VALUE}};',
                ],
                'condition'	=> [
                	'display_meta'	=> 'yes'
                ]
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_meta_typography',
				'selector' => '{{WRAPPER}} .meta-post span a',
				'condition'	=> [
                	'display_meta'	=> 'yes'
                ]
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
			<?php $blogpost = new \WP_Query(['post_type'  => 'post','posts_per_page' => 1]);
			if($blogpost->have_posts()) : while($blogpost->have_posts()) : $blogpost->the_post();
	            $format = get_post_format();
			?>
			<div class="latest-news">
				<article>
                    <div class="inner-post">
                        <h4 class="entry-title">
                            <a href="<?php the_permalink(); ?>"><?php  the_title(); ?></a>
                        </h4>
                        <?php if( $settings['exc'] ) { echo wp_specialchars_decode('<p>'.bigger_excerpt_length( $settings['exc'] ).'</p>'); }?>
                        <a class="pagelink" href="<?php the_permalink(); ?>">
                            <?php echo wp_specialchars_decode( $settings['btn'] ); ?>
                        </a>
                        <div class="is-bottom">
                        <?php if( $settings['display_meta'] ){ ?>
                        <div class="meta-post">
                        	<?php if( $settings['display_line'] ){ ?><div class="is-line"></div><?php } ?>
                        	<?php bigger_post_meta(); ?>
                        </div>
                    	<?php } ?>
                        </div>
                    </div>
                </article>
			</div>
			<?php endwhile; wp_reset_postdata(); endif; ?>
		<?php 
		
	}

	protected function _content_template() {}
}
// After the Bigger_Latest_News class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Latest_News() );