<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Image Slider
 */
class Bigger_Image_Carousel extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-image-carousel';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Image Carousel', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-slider-push';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Image Carousel', 'bigger' ),
			]
		);

		$this->add_control(
			'carousel',
			[
				'label' => __( 'Add Images', 'bigger' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
				'show_label' => false,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'setting_section',
			[
				'label' => __( 'Setting', 'bigger' ),
				'tab' => Controls_Manager::TAB_SETTINGS,
			]
		);

		$slides_show = range( 1, 7 );
		$slides_show = array_combine( $slides_show, $slides_show );

		$this->add_control(
			'slides_show',
			[
				'label' => __( 'Slides To Show', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'options' => $slides_show,
				'default' => '1'
			]
		);

		$this->add_control(
			'navigation',
			[
				'label' => __( 'Navigation', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'arrows',
				'options' => [
					'both' => __( 'Arrows and Dots', 'bigger' ),
					'arrows' => __( 'Arrows', 'bigger' ),
					'dots' => __( 'Dots', 'bigger' ),
					'none' => __( 'None', 'bigger' ),
				],
			]
		);

		$this->add_control(
            'auto',
            [
                'label' => __('Autoplay ?', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bigger'),
                'label_off' => __('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'navigation_section',
			[
				'label' => __( 'Navigation', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'navigation' => [ 'arrows', 'dots', 'both' ],
				],
			]
		);

		$this->add_control(
			'arrow_style',
			[
				'label' => __( 'Arrow', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'condition' => [
					'navigation' => [ 'arrows', 'both' ],
				],
			]
		);

		$this->add_control(
            'arrow_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .image-carousel .slick-arrow' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'navigation' => [ 'arrows', 'both' ],
				],
            ]
        );

        $this->add_control(
            'arrow_color_hover',
            [
                'label' => __( 'Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .image-carousel .slick-arrow:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'navigation' => [ 'arrows', 'both' ],
				],
            ]
        );

        $this->add_control(
            'bg_arrow_color',
            [
                'label' => __( 'Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .image-carousel .slick-arrow' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'navigation' => [ 'arrows', 'both' ],
				],
            ]
        );

        $this->add_control(
            'arrow_bg_color_hover',
            [
                'label' => __( 'Hover Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .image-carousel .slick-arrow:hover' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'navigation' => [ 'arrows', 'both' ],
				],
            ]
        );

        $this->add_control(
			'dot_style',
			[
				'label' => __( 'Dot', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'navigation' => [ 'dots', 'both' ],
				],
			]
		);

		$this->add_control(
            'dot_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'navigation' => [ 'dots', 'both' ],
				],
            ]
        );

        $this->add_control(
            'dot_color_active',
            [
                'label' => __( 'Color Active', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li.slick-active button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'navigation' => [ 'dots', 'both' ],
				],
            ]
        );

        $this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$arr  = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) ) ? 'true' : 'false';
		$dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) ) ? 'true' : 'false';

		if ( empty( $settings['carousel'] ) ) {
			return;
		}

		$slides = [];

		foreach ( $settings['carousel'] as  $attachment ) {

			$meta = wp_prepare_attachment_for_js($attachment['id']);
            $link = $meta['caption'];
            $image_html = wp_get_attachment_image($attachment['id'],'full');
            $link_tag = '';
			if( $link ){
				$link_tag = '<a href="'. $link .'" target="_blank">';
			}
			$slide_html = '<div><div class="img-item">' . $link_tag . '<figure>' . $image_html . '</figure>';

			if( $link ){
				$slide_html .= '</a>';
			}
			$slide_html .= '</div></div>';
			$slides[] = $slide_html;

		}
		if ( empty( $slides ) ) {
			return;
		}
		?>

		<div class="image-carousel-wraper">
			<div class="image-carousel" data-show="<?php echo esc_attr( $settings['slides_show'] ); ?>" data-arrow="<?php echo esc_attr( $arr ); ?>" data-dots="<?php echo esc_attr( $dots ); ?>" data-auto="<?php echo esc_attr( $settings['auto'] ); ?>">
		        <?php echo implode( '', $slides ); ?>
		    </div>
	    </div>
		<?php 
		
	}

	protected function _content_template() {}

}
// After the Bigger_Image_Carousel class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Image_Carousel() );