<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Iconbox 
 */
class Bigger_Icon_Box extends Widget_Base {

	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-icon-box';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Icon Box', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-icon-box';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	// The _register_controls method lets you define which controls (setting fields) your widget will have.
	protected function _register_controls() {

		//Content Icon box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'bigger' ),
			]
		);

		$this->add_control(
			'type_icon',
			[
				'label' => __( 'Type Icon', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => __( 'None', 'bigger' ),
					'icon' => __( 'Fontawesome', 'bigger' ),
					'image' => __( 'Image', 'bigger' ),
					'icustom' => __( 'Custom Icon', 'bigger' ),
				],
				'default' => 'image',
			]
		);

		$this->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'elementor' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition' => [
					'type_icon' => 'icon',
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'bigger' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri() . '/images/img_iconbox1.png',
				],
				'condition' => [
					'type_icon' => 'image',
				],
			]
		);

		$this->add_control(
			'icustom',
			[
				'label' => __( 'Icon Tag ', 'bigger' ),
				'description' => __( 'Get icon class at this link: http://oceanthemes.net/font-icons/bigger/ , ex: icon-Share', 'bigger' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 1,
				'condition' => [
					'type_icon' => 'icustom',
				],
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __( 'Title & Description', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Mechanical', 'bigger' ),
				'placeholder' => __( 'Enter your title', 'bigger' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'description',
			[
				'label' => '',
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( 'Far far away, behind the word mountains, far from the countri Vokalia and Consonantia, there live...', 'bigger' ),
				'placeholder' => __( 'Enter your description', 'bigger' ),
				'rows' => 10,
				'separator' => 'none',
				'show_label' => false,
			]
		);

		$this->add_control(
            'link_title',
            [
                'label' => __('Link Title ?', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bigger'),
                'label_off' => __('No', 'bigger'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
            'link_image',
            [
                'label' => __('Link Image ?', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bigger'),
                'label_off' => __('No', 'bigger'),
                'return_value' => 'yes',
                'default' => '',
                'condition' 	=> [
                	'type_icon' 	=> 'image',
                	'image[url]!' 		=> ''
                ]
            ]
        );

		$this->end_controls_section();

		// Button Icon box
		$this->start_controls_section(
			'section_button',
			[
				'label' => __( 'Button', 'bigger' ),
			]
		);

		$this->add_control(
			'text',
			[
				'label' => __( 'Text', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Read More', 'bigger' ),
				'placeholder' => __( 'Click here', 'bigger' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'bigger' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'bigger' ),
				'default' => [
					'url' => 'https://your-link.com',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);


		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'section_style_layout',
			[
				'label' => __( 'Layout', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
            'is_border',
            [
                'label' => __('Is Border?', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bigger'),
                'label_off' => __('No', 'bigger'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_responsive_control(
			'content_align',
			[
				'label' => __( 'Alignment', 'bigger' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => __( 'Left', 'bigger' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'bigger' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'bigger' ),
						'icon' => 'fa fa-align-right',
					],
					'justify' => [
						'title' => __( 'Justified', 'bigger' ),
						'icon' => 'fa fa-align-justify',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
				'default' => '',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'section_style_image',
			[
				'label' => __( 'Image', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'type_icon'	=>	'image'
				]
			]
		);

		$this->add_responsive_control(
			'image_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .icon-box-wrapper .icon-box-icon img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'image_size',
			[
				'label' => __( 'Width', 'bigger' ) . ' (%)',
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .icon-box-wrapper .icon-box-icon img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_icon',
			[
				'label' => __( 'Icon', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'type_icon'	=>	'icon'
				]
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .icon-box-wrapper .icon-box-icon .icon-awesome' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .icon-box-wrapper .icon-box-icon .icon-awesome i' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_icon_custom',
			[
				'label' => __( 'Icon Custom', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'type_icon'	=>	'icustom'
				]
			]
		);

		$this->add_control(
			'icon_custom_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .icon-box-wrapper .icon-box-icon .icon-custom' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_custom_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .icon-box-wrapper .icon-box-icon .icon-custom i' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_content',
			[
				'label' => __( 'Content', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'bigger' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'title_bottom_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .box-content h4' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .box-content h4' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_color_hover',
			[
				'label' => __( 'Hover', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .box-content h4 a:hover' => 'color: {{VALUE}};',
				],
				'condition'	 => [
					'link_title' 	=> 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .box-content h4',
				
			]
		);

		$this->add_control(
			'heading_description',
			[
				'label' => __( 'Description', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'desc_bottom_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .box-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .box-content p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'selector' => '{{WRAPPER}} .box-content p',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_button',
			[
				'label' => __( 'Button', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .box-content a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_color_hover',
			[
				'label' => __( 'Hover', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .box-content a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .box-content a',
			]
		);

		$this->end_controls_section();

	}

	// The render() method, which is where you actually render the code and generate the final HTML on the frontend using PHP.
	protected function render() {
		$settings = $this->get_settings_for_display();
		$has_icon = ! empty( $settings['type_icon'] ) && 'none' !== $settings['type_icon'];
		if ( ! isset( $settings['icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['icon'] = 'fa fa-star';
		}
		$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
		$is_new = ! isset( $settings['icon'] ) && Icons_Manager::is_migration_allowed();

		if ( ! empty( $settings['link']['url'] ) ) {
			$this->add_render_attribute( 'link', 'href', $settings['link']['url'] );
			if ( $settings['link']['is_external'] ) {
				$this->add_render_attribute( 'link', 'target', '_blank' );
			}

			if ( $settings['link']['nofollow'] ) {
				$this->add_render_attribute( 'link', 'rel', 'nofollow' );
			}
		}
		$link_attributes = $this->get_render_attribute_string( 'link' );

		?>
		<div class="icon-box-wrapper <?php if( !$settings['is_border'] ){echo 'no-border';} ?>">
			<?php if ( $has_icon ) : ?>
			<div class="icon-box-icon">
				<?php if( $settings['type_icon'] === 'icon' ){ ?>
					<span class="icon-awesome">
						<?php
						if ( $is_new || $migrated ) {
							Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
						} elseif ( ! empty( $settings['icon'] ) ) { ?>
							<i class="<?php echo esc_attr( $settings['icon'] ) ?>" aria-hidden="true"></i><?php
						}
						?>
					</span>
				
				<?php } elseif( $settings['type_icon'] === 'image' ){ ?>

					<?php if( $settings['link_image'] ){ ?><a <?php echo $link_attributes; ?>><?php } ?><img src="<?php echo $settings['image']['url']; ?>" alt=""><?php if( $settings['link_image'] ){ ?></a><?php } ?>
				<?php } elseif( $settings['type_icon'] === 'icustom' ){ ?>

					<span class="icon-custom">
						<i class="icon <?php echo $settings['icustom']; ?>" aria-hidden="true"></i>
					</span>
				<?php } ?>
			</div>
			<?php endif; ?>
			<div class="box-content">
				<?php if( $settings['title'] ){ ?><h4><?php if( $settings['link_title'] ){ ?><a <?php echo $link_attributes; ?>><?php } echo $settings['title']; ?><?php if( $settings['link_title'] ){ ?></a><?php } ?></h4><?php } ?>
				<p><?php echo $settings['description']; ?></p>
				<?php if( $settings['text'] && $settings['link'] ) : ?>
					<a class="pagelink gray" <?php echo $link_attributes; ?>><?php echo $settings['text']; ?></a>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}

	// The _content_template() method, is where you render the editor output to generate the live preview using a Backbone JavaScript template.
	protected function _content_template() {

	}

}
// After the Bigger_Icon_Box class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Icon_Box() );