<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Fun facts 
 */
class Bigger_Fun_Facts extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-fun-facts';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Fun Facts', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-counter';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'bigger' ),
			]
		);

		$this->add_control(
			'type_icon',
			[
				'label' => __( 'Type Icon', 'bigger' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => __( 'None', 'bigger' ),
					'icon' => __( 'Fontawesome', 'bigger' ),
					'image' => __( 'Image', 'bigger' ),
					'icustom' => __( 'Custom Icon', 'bigger' ),
				],
				'default' => 'image',
			]
		);

		$this->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'elementor' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition' => [
					'type_icon' => 'icon',
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'bigger' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => get_template_directory_uri() . '/images/img_iconbox1.png',
				],
				'condition' => [
					'type_icon' => 'image',
				],
			]
		);

		$this->add_control(
			'icustom',
			[
				'label' => __( 'Class Icon ', 'bigger' ),
				'description' => __( 'Get icon class at this link: http://oceanthemes.net/font-icons/bigger/ , ex: icon-Share', 'bigger' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 1,
				'condition' => [
					'type_icon' => 'icustom',
				],
			]
		);
		
		$this->add_control(
			'number',
			[
				'label' => __( 'Number', 'bigger' ),
				'type' => Controls_Manager::NUMBER,
				'dynamic' => [
					'active' => true,
				],
				'default' => '',
			]
		);

		$this->add_control(
			'symboy',
			[
				'label' => __( 'Symbol', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => '',
				'label_block' => true,
			]
		);

		$this->add_control(
			'text',
			[
				'label' => __( 'Text', 'bigger' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Affiliate Companies', 'bigger' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_icon',
			[
				'label' => __( 'Icon', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'type_icon'	=> 'icon'
				]
			]
		);

		$this->add_responsive_control(
			'icon_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default'=> [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .fun-facts .icon-fact' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Size', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 15,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .fun-facts .icon-fact' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .fun-facts .icon-fact' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_image',
			[
				'label' => __( 'Image', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'type_icon'	=> 'image'
				]
			]
		);

		$this->add_responsive_control(
			'image_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default'=> [
					'size'	=> '20'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .fun-facts .icon-fact' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'image_width',
			[
				'label' => __( 'Width', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .fun-facts .icon-fact img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_icon_custom',
			[
				'label' => __( 'Icon Custom', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'type_icon'	=> 'icustom'
				]
			]
		);

		$this->add_responsive_control(
			'icon_custom_space',
			[
				'label' => __( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default'=> [
					'size'	=> '20'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .fun-facts .icon-fact' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_custom_size',
			[
				'label' => __( 'Size', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 15,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .fun-facts .icon-fact' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_custom_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .fun-facts .icon-fact' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_number',
			[
				'label' => __( 'Number', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'number_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .fun-facts .counter span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'number_typography',
				'selector' => '{{WRAPPER}} .fun-facts .counter span',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_content',
			[
				'label' => __( 'Content', 'bigger' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'content_color',
			[
				'label' => __( 'Color', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .fun-facts .counter h6' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .fun-facts .counter h6',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$has_icon = ! empty( $settings['type_icon'] ) && 'none' !== $settings['type_icon'];
		if ( ! isset( $settings['icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['icon'] = 'fa fa-star';
		}
		$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );
		$is_new = ! isset( $settings['icon'] ) && Icons_Manager::is_migration_allowed();
		?>
		<div class="fun-facts">
			<?php if ( $has_icon ) : ?>
			<div class="icon-fact">
				<?php if( $settings['type_icon'] === 'icon' ){ ?>
					<span class="icon-awesome">
						<?php
						if ( $is_new || $migrated ) {
							Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
						} elseif ( ! empty( $settings['icon'] ) ) { ?>
							<i class="<?php echo esc_attr( $settings['icon'] ) ?>" aria-hidden="true"></i><?php
						}
						?>
					</span>
					<?php } elseif( $settings['type_icon'] === 'image' ){ ?>
				<img src="<?php echo $settings['image']['url']; ?>">
				<?php }elseif( $settings['type_icon'] === 'icustom' ){ ?>
					<i class="icon <?php echo $settings['icustom']; ?>" aria-hidden="true"></i>
				<?php } ?>
			</div>
			<?php endif; ?>
			<div class="counter">
		        <span class="number bolder" data-to="<?php echo $settings['number'] ?>" data-inviewport="yes">0</span><span class="number-suffix bolder"><?php echo $settings['symboy'] ?></span> 
		        <h6><?php echo $settings['text'] ?></h6>
	        </div>
	    </div>
	    <?php
	}

	protected function _content_template() {}
}
// After the Bigger_Fun_Facts class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Fun_Facts() );