<?php 
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Feature Portfolio 
 */
class Bigger_Feature_Portfolio extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'bigger-feature-project';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'Bigger Feature Portfolio', 'bigger' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-slideshow';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_bigger' ];
	}

	protected function _register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'bigger' ),
			]
		);

		$this->add_control(
			'idpost',
			[
				'label' => __( 'Projects List', 'bigger' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $this->select_param_project(),
				'multiple' => true,
				'label_block' => true
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'setting_section',
			[
				'label' => __( 'Setting', 'bigger' ),
				'tab' => Controls_Manager::TAB_SETTINGS,
			]
		);

		$this->add_control(
            'auto',
            [
                'label' => __('Autoplay', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bigger'),
                'label_off' => __('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

        $this->add_control(
            'arrows',
            [
                'label' => __('Slide Arrows', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bigger'),
                'label_off' => __('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

        $this->add_control(
            'dots',
            [
                'label' => __('Slide Dot', 'bigger'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bigger'),
                'label_off' => __('No', 'bigger'),
                'return_value' => 'true',
                'default' => 'false',
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'text_style_section',
			[
				'label' => __( 'Content', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'bigger' ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'title_space',
			[
				'label' => esc_html__( 'Spacing', 'bigger' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .project-item .inner h4' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-item .inner h4 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
			'title_color_hover',
			[
				'label' => __( 'Hover', 'bigger' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-item .inner h4 a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .project-item .inner h4 a',
				
			]
		);

		$this->add_control(
			'heading_img',
			[
				'label' => __( 'Image', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
            'img_overlay_color',
            [
                'label' => esc_html__( 'Overlay', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-overlay' => 'background-image: linear-gradient(to top, {{VALUE}}, rgba(0, 0, 0, 0));',
                ],
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
			'navigation_section',
			[
				'label' => __( 'Navigation', 'bigger' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'arrow_style',
			[
				'label' => __( 'Arrow', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'condition' => [
					'arrows' => 'true'
				]
			]
		);

		$this->add_control(
            'arrow_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-slider .slick-arrow' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );


		$this->add_control(
            'arrow_color_hover',
            [
                'label' => __( 'Hover', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-slider .slick-arrow:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
            'bg_arrow_color',
            [
                'label' => __( 'Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-slider .slick-arrow' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
            'arrow_bg_color_hover',
            [
                'label' => __( 'Hover Backgroud Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-slider .slick-arrow:hover' => 'background: {{VALUE}};',
                ],
                'condition' => [
					'arrows' => 'true'
				]
            ]
        );

        $this->add_control(
			'dot_style',
			[
				'label' => __( 'Dot', 'bigger' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'dots' => 'true'
				]
			]
		);

		$this->add_control(
            'dot_color',
            [
                'label' => __( 'Color', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'dots' => 'true'
				]
            ]
        );

        $this->add_control(
            'dot_color_active',
            [
                'label' => __( 'Color Active', 'bigger' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li.slick-active button:before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
					'dots' => 'true'
				]
            ]
        );

        $this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="feature-project-wraper">
			<div class="project-slider projects-feature" data-show="1" data-arrow="<?php echo esc_attr( $settings['arrows'] ) ?>" data-dots="<?php echo esc_attr( $settings['dots'] ) ?>" data-auto="<?php echo esc_attr( $settings['auto'] ) ?>">
				<?php

		        $args = array(
		            'post_type' => 'ot_portfolio',
		            'posts_per_page' => -1,
		            'post__in' => $settings['idpost']
		        );
		        $wp_query = new \WP_Query($args);

		        while ($wp_query -> have_posts()) : $wp_query -> the_post();
		        $cates = get_the_terms(get_the_ID(),'portfolio_cat');
	                $cate_name ='';
	                foreach((array)$cates as $cate){
	                    if(count($cates)>0){
	                        $cate_name .= $cate->name .'<span>, </span>';
	                    }
	                }
		        ?>
		        	<div>
		                <div class="project-item">
		                    <div class="inner">
		                    	<?php if( function_exists( 'rwmb_meta' ) ) { 
			                        $images = rwmb_meta( 'slide', "type=image" );
			                        foreach ( $images as $image ) {  
			                        	$img = $image['full_url']; 
			                        ?>
			                        <a href="<?php the_permalink(); ?>">
			                        	<img class="" src="<?php echo esc_url($img); ?>" alt="<?php the_title(); ?>">
			                        	<div class="item-overlay"></div>
			                        </a>
		                        <?php } } ?>

		                        <div class="title-cat">
		                        	<h4 class="text-light">
		                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
		                            </h4>
		                            <h6><?php echo wp_specialchars_decode($cate_name); ?></h6>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        <?php endwhile; wp_reset_postdata();?>
			</div>
		</div>
	    <?php
	}

	protected function _content_template() {}

	protected function select_param_project() {
	    $args = array(
	        'numberposts' => -1, // 'numberposts' and 'posts_per_page' can be used interchangeably.
	        'post_type'   => 'ot_portfolio'
	    );
	    $posts = get_posts( $args );
	    $cat = array();
	    foreach( $posts as $post ) {
	        if( $post ) {
	            $cat[$post->ID] = $post->post_title;
	        }
	    }
	    return $cat;
	}
}
// After the Bigger_Feature_Portfolio class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Bigger_Feature_Portfolio() );