<?php
function typography_customize_settings() {
    /**
     * Customizer configuration
     */

    $settings = array(
        'theme' => 'bigger',
    );

    $panels = array(
        
    );

    $sections = array(
        'typography'           => array(
            'title'       => esc_html__( 'Typography', 'bigger' ),
            'description' => '',
            'priority'    => 15,
            'capability'  => 'edit_theme_options',
        ),
    );

    $fields = array(
        // Typography
        'body_typo'    => array(
            'type'     => 'typography',
            'label'    => esc_html__( 'Body', 'bigger' ),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => 'Poppins',
                'variant'        => 'regular',
                'font-size'      => '15px',
                'line-height'    => '1.86',
                'letter-spacing' => '0',
                'subsets'        => array( 'latin-ext' ),
                'color'          => '#000000',
                'text-transform' => 'none',
            ),
        ),
        'heading1_typo'                           => array(
            'type'     => 'typography',
            'label'    => esc_html__( 'Heading 1', 'bigger' ),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => 'Poppins',
                'variant'        => '600',
                'font-size'      => '36px',
                'line-height'    => '1.33',
                'letter-spacing' => '0',
                'subsets'        => array( 'latin-ext' ),
                'color'          => '#051f45',
                'text-transform' => 'none',
            ),
        ),
        'heading2_typo'                           => array(
            'type'     => 'typography',
            'label'    => esc_html__( 'Heading 2', 'bigger' ),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => 'Poppins',
                'variant'        => '600',
                'font-size'      => '30px',
                'line-height'    => '1.33',
                'letter-spacing' => '0',
                'subsets'        => array( 'latin-ext' ),
                'color'          => '#051f45',
                'text-transform' => 'none',
            ),
        ),
        'heading3_typo'                           => array(
            'type'     => 'typography',
            'label'    => esc_html__( 'Heading 3', 'bigger' ),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => 'Poppins',
                'variant'        => '600',
                'font-size'      => '24px',
                'line-height'    => '1.33',
                'letter-spacing' => '0',
                'subsets'        => array( 'latin-ext' ),
                'color'          => '#051f45',
                'text-transform' => 'none',
            ),
        ),
        'heading4_typo'                           => array(
            'type'     => 'typography',
            'label'    => esc_html__( 'Heading 4', 'bigger' ),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => 'Poppins',
                'variant'        => '600',
                'font-size'      => '18px',
                'line-height'    => '1.33',
                'letter-spacing' => '0',
                'subsets'        => array( 'latin-ext' ),
                'color'          => '#051f45',
                'text-transform' => 'none',
            ),
        ),
        'heading5_typo'                           => array(
            'type'     => 'typography',
            'label'    => esc_html__( 'Heading 5', 'bigger' ),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => 'Poppins',
                'variant'        => '600',
                'font-size'      => '16px',
                'line-height'    => '1.33',
                'letter-spacing' => '0',
                'subsets'        => array( 'latin-ext' ),
                'color'          => '#051f45',
                'text-transform' => 'none',
            ),
        ),
        'heading6_typo'                           => array(
            'type'     => 'typography',
            'label'    => esc_html__( 'Heading 6', 'bigger' ),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => 'Poppins',
                'variant'        => '600',
                'font-size'      => '12px',
                'line-height'    => '1.33',
                'letter-spacing' => '0',
                'subsets'        => array( 'latin-ext' ),
                'color'          => '#051f45',
                'text-transform' => 'none',
            ),
        ),
        'menu_typo'                               => array(
            'type'     => 'typography',
            'label'    => esc_html__( 'Menu', 'bigger' ),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => 'Poppins',
                'variant'        => '500',
                'subsets'        => array( 'latin-ext' ),
                'font-size'      => '13px',
                'text-transform' => 'none',
            ),
        ),

    );

    $settings['panels']   = apply_filters( 'bigger_customize_panels', $panels );
    $settings['sections'] = apply_filters( 'bigger_customize_sections', $sections );
    $settings['fields']   = apply_filters( 'bigger_customize_fields', $fields );

    return $settings;
}

$bigger_customize = new Bigger_Customize( typography_customize_settings() );