<?php
function header_customize_settings() {
	/**
	 * Customizer configuration
	 */

	$settings = array(
		'theme' => 'bigger',
	);

	$panels = array(	
	    'header'        => array(
			'title'      => esc_html__( 'Header', 'bigger' ),
			'priority'   => 9,
			'capability' => 'edit_theme_options',
		),
	);

	$sections = array(
        'main_header'           => array(
            'title'       => esc_html__( 'General', 'bigger' ),
            'description' => '',
            'priority'    => 15,
            'capability'  => 'edit_theme_options',
            'panel'       => 'header',
        ),
		'topbar_header'           => array(
			'title'       => esc_html__( 'Top Bar', 'bigger' ),
			'description' => '',
			'priority'    => 16,
			'capability'  => 'edit_theme_options',
			'panel'       => 'header',
		),
        'logo_header'           => array(
            'title'       => esc_html__( 'Logo', 'bigger' ),
            'description' => '',
            'priority'    => 17,
            'capability'  => 'edit_theme_options',
            'panel'       => 'header',
        ),
        'menu_header'           => array(
            'title'       => esc_html__( 'Menu', 'bigger' ),
            'description' => '',
            'priority'    => 18,
            'capability'  => 'edit_theme_options',
            'panel'       => 'header',
        ),
	    'header_styling'           => array(
			'title'       => esc_html__( 'Styling', 'bigger' ),
			'description' => '',
			'priority'    => 19,
			'capability'  => 'edit_theme_options',
			'panel'       => 'header',
		),
		'header_mobile_styling'  => array(
			'title'       => esc_html__( 'Mobile Styling', 'bigger' ),
			'description' => '',
			'priority'    => 20,
			'capability'  => 'edit_theme_options',
			'panel'       => 'header',
		),
		'preload_section'     => array(
			'title'       => esc_attr__( 'Preloader', 'bigger' ),
			'description' => '',
			'priority'    => 15,
			'capability'  => 'edit_theme_options',
		),
	);

	$fields = array(		

		// Topbar Header
		'topbar_switch'     => array(
			'type'        => 'toggle',
			'label'       => esc_attr__( 'Top Bar On/Off?', 'bigger' ),
			'section'     => 'topbar_header',
			'default'     => 1,
			'priority'    => 1,
		),

		// Header Contact Info
		'info_switch'     => array(
			'type'        => 'toggle',
			'label'       => esc_attr__( 'Info On/Off?', 'bigger' ),
			'section'     => 'topbar_header',
			'default'     => 1,
			'priority'    => 1,
		),
		'info_separator'     => array(
			'type'        => 'custom',
			'label'       => '',
			'section'     => 'topbar_header',
			'default'     => '<hr>',
			'priority'    => 2,
		),
		'header_contact_info'     => array(
			'type'     => 'repeater',
			'label'    => esc_html__( 'Contact Info', 'bigger' ),
			'section'  => 'topbar_header',
			'priority' => 4,
			'row_label' => array(
				'type' => 'field',
				'value' => esc_attr__('Contact Info', 'bigger' ),
				'field' => 'info_name',
			),
            'active_callback' => array(
                array(
                    'setting'  => 'info_switch',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
			'default'  => array(),
			'fields'   => array(
				'info_name' => array(
					'type'        => 'text',
					'label'       => esc_html__( 'Contact info name', 'bigger' ),
					'description' => esc_html__( 'This will be the contact info name', 'bigger' ),
					'default'     => '',
				),
				'info_icon' => array(
					'type'        => 'textarea',
					'label'       => esc_html__( 'Icon Code', 'bigger' ),
					'description' => esc_html__( 'This will be the contact info icon: https://fontawesome.com/icons , Ex: <i class="fas fa-phone"></i>', 'bigger' ),
					'default'     => '',
				),
				'info_content' => array(
					'type'        => 'textarea',
					'label'       => esc_html__( 'Contact info content', 'bigger' ),
					'description' => esc_html__( 'This will be the contact info content', 'bigger' ),
					'default'     => '',
				),				
			),
		),

		//Header CTA
		'cta_separator'     => array(
			'type'        => 'custom',
			'label'       => '',
			'section'     => 'topbar_header',
			'default'     => '<hr>',
			'priority'    => 4,
		),
		'cta_top'     => array(
			'type'     => 'repeater',
			'label'    => esc_html__( 'CTA Button', 'bigger' ),
			'section'  => 'topbar_header',
			'priority' => 4,
			'row_label' => array(
				'type' => 'field',
				'value' => esc_attr__('Button', 'bigger' ),
				'field' => 'btn_text',
			),
			'fields'   => array(
				'btn_text' => array(
					'type'        => 'text',
					'label'       => esc_html__( 'Label Button', 'bigger' ),
					'description' => esc_html__( 'This will be the text of button', 'bigger' ),
					'default'     => '',
				),
				'btn_link' => array(
					'type'        => 'text',
					'label'       => esc_html__( 'Link Button', 'bigger' ),
					'description' => esc_html__( 'This will be the link of button', 'bigger' ),
					'default'     => '',
				),				
			),
		),

		// Main Header
        'header_layout'    => array(
            'type'        => 'radio-image',
            'label'       => esc_attr__( 'Header Layout', 'bigger' ),
            'section'     => 'main_header',
            'default'     => 'header1',
            'priority'    => 1,
            'multiple'    => 1,
            'choices'     => array(
                'header1' => get_template_directory_uri() . '/images/header-layout1.jpg',
                'header2' => get_template_directory_uri() . '/images/header-layout2.jpg',
                'header3' => get_template_directory_uri() . '/images/header-layout3.jpg',
                'header4' => get_template_directory_uri() . '/images/header-layout4.jpg',
            ),
        ),
        'home_header_transperant_switch'     => array(
			'type'        => 'toggle',
			'label'       => esc_attr__( 'Home Header Transparent On/Off?', 'bigger' ),
			'section'     => 'main_header',
			'default'     => 0,
			'priority'    => 2,
		),
        'header_desktop_sticky'        => array(
            'type'     => 'toggle',
            'label'    => esc_html__( 'Sticky Header On Desktop', 'bigger' ),
            'section'  => 'main_header',
            'default'  => '1',
            'priority' => 3,
        ),
        'header_mobile_sticky'        => array(
            'type'     => 'toggle',
            'label'    => esc_html__( 'Sticky Header On Mobile', 'bigger' ),
            'section'  => 'main_header',
            'default'  => '1',
            'priority' => 3,
        ),       
        'search_switch'     => array(
            'type'        => 'toggle',
            'label'       => esc_attr__( 'Search Button On/Off?', 'bigger' ),
            'section'     => 'main_header',
            'default'     => 1,
            'priority'    => 4,
        ),      
        'separator_ctahead'     => array(
            'type'        => 'custom',
            'label'       => '',
            'section'     => 'main_header',
            'default'     => '<hr>',
            'priority'    => 5,
        ),
        'cta_phone_header'      => array(
            'type'        => 'text',
            'label'       => esc_html__( 'Phone Number', 'bigger' ),
            'section'     => 'main_header',
            'default'     => '+84 1900 81988',
            'priority'    => 6,
            'active_callback' => array(
                array(
                    'setting'  => 'header_layout',
                    'operator' => '==',
                    'value'    => 'header2',
                ),
            ),
        ),    

		// Logo Setting
		'logo'         => array(
			'type'     => 'image',
			'label'    => esc_attr__( 'Upload Your Static Logo Image on Header Static (.jpg, .png, .svg)', 'bigger' ),
			'section'  => 'logo_header',
			'default'  => trailingslashit( get_template_directory_uri() ) . 'images/logo.png',
			'priority' => 3,
		),
		'logo_scroll'         => array(
			'type'     => 'image',
			'label'    => esc_attr__( 'Upload Your Logo Image on Header Scroll (.jpg, .png, .svg)', 'bigger' ),
			'section'  => 'logo_header',
			'default'  => trailingslashit( get_template_directory_uri() ) . 'images/logo.png',
			'priority' => 3,
		),
        'logo_width'     => array(
            'type'     => 'number',
            'label'    => esc_html__( 'Logo Width(px)', 'bigger' ),
            'section'  => 'logo_header',
            'priority' => 4,
            'default'  => '',
            'output'    => array(
                array(
                    'element'  => '#logo-header a img',
                    'property' => 'width',
                    'units'	   => 'px'
                ),
            ),
        ),
        'logo_height'    => array(
            'type'     => 'number',
            'label'    => esc_html__( 'Logo Height(px)', 'bigger' ),
            'section'  => 'logo_header',
            'priority' => 5,
            'default'  => '',
            'output'    => array(
                array(
                    'element'  => '#logo-header a img',
                    'property' => 'height',
                    'units'	   => 'px'
                ),
            ),
        ),
        'logo_spacing'  => array(
            'type'     => 'dimensions',
            'label'    => esc_html__( 'Logo Margin (ex: 10px)', 'bigger' ),
            'section'  => 'logo_header',
            'priority' => 6,
            'default'  => array(
                'top'    => '0',
                'bottom' => '0',
                'left'   => '0',
                'right'  => '0',
            ),
            'output'    => array(
                array(
                    'element'  => '#logo-header',
                    'property' => 'padding',
                    'units'	   => 'px'
                ),
            ),
        ),

        //Header Styling        
        'separator_tophead'     => array(
            'type'        => 'custom',
            'label'       => '',
            'section'     => 'header_styling',
            'default'     => '<hr>',
            'priority'    => 8,
        ),
        'bg_topbar'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Top Bar Background Color', 'bigger' ),
            'section'  => 'header_styling',
            'default'  => '',
            'priority' => 9,
            'output'    => array(
                array(
                    'element'  => '.top-bar',
                    'property' => 'background'
                ),
            ),
        ),
        'color_topbar'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Top Bar Text Color', 'bigger' ),
            'section'  => 'header_styling',
            'default'  => '',
            'priority' => 11,
            'output'    => array(
                array(
                    'element'  => '.inner-top .info-top ul li',
                    'property' => 'color'
                ),
            ),
		),
        'cta_bgcolor_header'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'CTA Button Background Color', 'bigger' ),
            'section'  => 'header_styling',
            'default'  => '',
            'priority' => 11,
            'output'    => array(
                array(
                    'element'  => '.top-bar .inner-top a.btn',
                    'property' => 'background'
                ),
            ),
        ),
        
        'cta_textcolor_header'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'CTA Button Text Color', 'bigger' ),
            'section'  => 'header_styling',
            'default'  => '',
            'priority' => 11,
            'output'    => array(
                array(
                    'element'  => '.top-bar .inner-top a.btn',
                    'property' => 'color'
                ),
            ),
        ),
		'separator_1'     => array(
            'type'        => 'custom',
            'label'       => '',
            'section'     => 'header_styling',
            'default'     => '<hr>',
            'priority'    => 12,
        ),
        'separator_1'     => array(
            'type'        => 'custom',
            'label'       => '',
            'section'     => 'header_styling',
            'default'     => '<hr>',
            'priority'    => 12,
        ),
        'bg_menu'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Main Navigation Background Color', 'bigger' ),
            'section'  => 'header_styling',
            'default'  => '',
            'priority' => 13,
            'output'    => array(
                array(
                    'element'  => '.main-header',
                    'property' => 'background'
                ),
            ),
        ),
        'color_menu'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Menu Item Color', 'bigger' ),
            'section'  => 'header_styling',
            'default'  => '',
            'priority' => 14,
            'output'    => array(
                array(
                    'element'  => '.main-header .main-navigation ul li a, .search-cart-box .h-cart-btn i, .search-cart-box .toggle_search i',
                    'property' => 'color'
                ),
            ),
        ),
        'separator_2'     => array(
            'type'        => 'custom',
            'label'       => '',
            'section'     => 'header_styling',
            'default'     => '<hr>',
            'priority'    => 15,
        ),
        'bg_smenu'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Background Color for Dropdown Menu', 'bigger' ),
            'section'  => 'header_styling',
            'default'  => '',
            'priority' => 16,
            'output'    => array(
                array(
                    'element'  => '.main-navigation .sub-menu',
                    'property' => 'background'
                ),                
            ),
        ),
        'color_smenu'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Color for Dropdown Menu Item', 'bigger' ),
            'section'  => 'header_styling',
            'default'  => '',
            'priority' => 18,
            'output'    => array(
                array(
                    'element'  => '.main-header .main-navigation ul li li a',
                    'property' => 'color'
                ),
            ),
        ),

        'hmobile_style'    => array(
            'type'        => 'select',
            'label'       => esc_attr__( 'Header Style', 'bigger' ),
            'section'     => 'header_mobile_styling',
            'default'     => 'stylelight',
            'priority'    => 1,
            'multiple'    => 1,
            'choices'     => array(
                'stylelight' => 'Light Style',
                'styledark' => 'Dark Style',
				'styleblue' => 'Blue Style',                
            ),
        ),

        // Preloader Setting
        'preload'     => array(
            'type'        => 'toggle',
            'label'       => esc_attr__( 'Preloader', 'bigger' ),
            'section'     => 'preload_section',
            'default'     => '1',
            'priority'    => 10,
        ),
        'preload_logo'    => array(
            'type'     => 'image',
            'label'    => esc_html__( 'Logo Preload', 'bigger' ),
            'section'  => 'preload_section',
            'default'  => trailingslashit( get_template_directory_uri() ) . 'images/logo.png',
            'priority' => 11,
            'active_callback' => array(
                array(
                    'setting'  => 'preload',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'preload_logo_width'     => array(
            'type'     => 'number',
            'label'    => esc_html__( 'Logo Width', 'bigger' ),
            'section'  => 'preload_section',
            'default'  => 152,
            'priority' => 12,
            'active_callback' => array(
                array(
                    'setting'  => 'preload',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'preload_logo_height'    => array(
            'type'     => 'number',
            'label'    => esc_html__( 'Logo Height', 'bigger' ),
            'section'  => 'preload_section',
            'default'  => 70,
            'priority' => 13,
            'active_callback' => array(
                array(
                    'setting'  => 'preload',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'preload_text_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Text Color', 'bigger' ),
            'section'  => 'preload_section',
            'default'  => '#0a0f2b',
            'priority' => 14,
            'active_callback' => array(
                array(
                    'setting'  => 'preload',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'preload_bgcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Background Color', 'bigger' ),
            'section'  => 'preload_section',
            'default'  => '#fff',
            'priority' => 15,
            'active_callback' => array(
                array(
                    'setting'  => 'preload',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'preload_typo' => array(
            'type'        => 'typography',
            'label'       => esc_attr__( 'Preload Font', 'bigger' ),
            'section'     => 'preload_section',
            'default'     => array(
                'font-family'    => 'Roboto',
                'variant'        => 'regular',
                'font-size'      => '13px',
                'line-height'    => '40px',
                'letter-spacing' => '2px',
                'subsets'        => array( 'latin-ext' ),                
                'text-transform' => 'none',
                'text-align'     => 'center'
            ),
            'priority'    => 16,
            'output'      => array(
                array(
                    'element' => '#royal_preloader.royal_preloader_logo .royal_preloader_percentage',
                ),
            ),
        ),
	);

	$settings['panels']   = apply_filters( 'bigger_customize_panels', $panels );
	$settings['sections'] = apply_filters( 'bigger_customize_sections', $sections );
	$settings['fields']   = apply_filters( 'bigger_customize_fields', $fields );

	return $settings;
}

$bigger_customize = new Bigger_Customize( header_customize_settings() );