<?php
function footer_customize_settings() {
	/**
	 * Customizer configuration
	 */

	$settings = array(
		'theme' => 'bigger',
	);

	$panels = array(	
		// Footer Customize Panel
	    'footer'        => array(
			'title'      => esc_html__( 'Footer', 'bigger' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
		),
	);

	$sections = array(		
		'logo_footer'           => array(
            'title'       => esc_html__( 'Logo', 'bigger' ),
            'description' => '',
            'priority'    =>17,
            'capability'  => 'edit_theme_options',
            'panel'       => 'footer',
        ),	
		'main_footer'           => array(
            'title'       => esc_html__( 'Footer Content', 'bigger' ),
            'description' => '',
            'priority'    => 20,
            'capability'  => 'edit_theme_options',
            'panel'       => 'footer',
        ),
        'footer_styling'           => array(
            'title'       => esc_html__( 'Footer Styling', 'bigger' ),
            'description' => '',
            'priority'    => 21,
            'capability'  => 'edit_theme_options',
            'panel'       => 'footer',
        ),
	);

	$fields = array(		
		//Footer Widgets
		'footer_widgets'     => array(
            'type'        => 'toggle',
            'label'       => esc_attr__( 'Footer Widgets On/Off?', 'bigger' ),
            'section'     => 'main_footer',
            'default'     => 1,
            'priority'    => 3,
        ),

        // Footer Content
        'footer_bottom'     => array(
            'type'        => 'toggle',
            'label'       => esc_attr__( 'Footer Bottom On/Off?', 'bigger' ),
            'section'     => 'main_footer',
            'default'     => 1,
            'priority'    => 3,
        ),

        //Footer Styling
        'bg_footer'    => array(
            'type'     => 'image',
            'label'    => esc_html__( 'Background Top Footer', 'bigger' ),
            'section'  => 'footer_styling',
            'priority' => 1,
            'output'    => array(
                array(
                    'element'  => '.main-footer',
                    'property' => 'background-image',
                ),
            ),
            'default'  => trailingslashit( get_template_directory_uri() ) . 'images/bg_footer.jpg',
        ),
        'color_footer' => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Background Color Top Footer', 'bigger' ),
            'section'  => 'footer_styling',
            'priority' => 2,
            'output'    => array(
                array(
                    'element'  => '.main-footer h4, .main-footer .padd-textwidget, .main-footer .text-primary, .site-footer .main-footer ul li a',
                    'property' => 'color',
                ),
            ),
        ),
        'cta_separator'     => array(
            'type'        => 'custom',
            'label'       => '',
            'section'     => 'footer_styling',
            'default'     => '<hr>',
            'priority'    => 3,
        ),
        'bg_bfooter'    => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Background Color Bottom Footer', 'bigger' ),
            'section'  => 'footer_styling',
            'priority' => 4,
            'output'    => array(
                array(
                    'element'  => 'footer .bot-footer',
                    'property' => 'background-color',
                ),
            ),
        ),
        'color_bfooter' => array(
            'type'     => 'color',
            'label'    => esc_html__( 'Color Bottom Footer', 'bigger' ),
            'section'  => 'footer_styling',
            'priority' => 5,
            'output'    => array(
                array(
                    'element'  => '.site-footer .bot-footer ul li a, .footer-copyright',
                    'property' => 'color',
                )
            ),
        ),

        //Logo
        'logo_footer'         => array(
			'type'     => 'image',
			'label'    => esc_attr__( 'Logo Footer', 'bigger' ),
			'section'  => 'logo_footer',
			'default'  => trailingslashit( get_template_directory_uri() ) . 'images/logo-footer.png',
			'priority' => 3,
		),
		'logof_width'     => array(
            'type'     => 'number',
            'label'    => esc_html__( 'Logo Width(px)', 'bigger' ),
            'section'  => 'logo_footer',
            'priority' => 4,
            'default'  => '',
            'output'    => array(
                array(
                    'element'  => '#logo-footer a img',
                    'property' => 'width',
                    'units'	   => 'px'
                ),
            ),
        ),
        'logof_height'    => array(
            'type'     => 'number',
            'label'    => esc_html__( 'Logo Height(px)', 'bigger' ),
            'section'  => 'logo_footer',
            'priority' => 5,
            'default'  => '',
            'output'    => array(
                array(
                    'element'  => '#logo-footer a img',
                    'property' => 'height',
                    'units'	   => 'px'
                ),
            ),
        ),
        'logof_spacing'  => array(
            'type'     => 'dimensions',
            'label'    => esc_html__( 'Logo Margin (ex: 10px)', 'bigger' ),
            'section'  => 'logo_footer',
            'priority' => 6,
            'default'  => array(
                'top'    => '0',
                'bottom' => '0',
                'left'   => '0',
                'right'  => '0',
            ),
            'output'    => array(
                array(
                    'element'  => '#logo-footer',
                    'property' => 'padding',
                    'units'	   => 'px'
                ),
            ),
        ),

		//Copyright	
        'copyright'     => array(
            'type'        => 'textarea',
            'label'       => esc_attr__( 'Copyright', 'bigger' ),
            'section'     => 'main_footer',
            'priority'    => 6,
            'active_callback' => array(
                array(
                    'setting'  => 'footer_bottom',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),

        //Social
		'socials_contact'     => array(
            'type'     => 'repeater',
            'label'    => esc_html__( 'Socials Contact', 'bigger' ),
            'section'  => 'main_footer',
            'priority' => 4,
            'active_callback' => array(
                array(
                    'setting'  => 'footer_bottom',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
            'row_label' => array(
                'type' => 'field',
                'value' => esc_attr__('Social', 'bigger' ),
                'field' => 'social_name',
            ),
            'default'  => array(),
            'fields'   => array(
            	'social_icon' => array(
                    'type'        => 'textarea',
                    'label'       => esc_html__( 'Icon class name', 'bigger' ),
                    'description' => esc_html__( 'This will be the contact info icon: https://fontawesome.com/icons/ , ex: <i class="fab fa-facebook-f"></i>', 'bigger' ),
                    'default'     => '',
                ),
                'social_link' => array(
                    'type'        => 'textarea',
                    'label'       => esc_html__( 'Link', 'bigger' ),
                    'description' => esc_html__( 'This will be the link social of you', 'bigger' ),
                    'default'     => '',
                ),
            ),
        ),
	);

	$settings['panels']   = apply_filters( 'bigger_customize_panels', $panels );
	$settings['sections'] = apply_filters( 'bigger_customize_sections', $sections );
	$settings['fields']   = apply_filters( 'bigger_customize_fields', $fields );

	return $settings;
}

$bigger_customize = new Bigger_Customize( footer_customize_settings() );