<?php
function blog_customize_settings() {
	/**
	 * Customizer configuration
	 */

	$settings = array(
		'theme' => 'bigger',
	);

	$panels = array(	
	    'blog'        => array(
			'title'      => esc_html__( 'Blog', 'bigger' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
		),
	);

	$sections = array(
		'blog_page'           => array(
			'title'       => esc_html__( 'Blog Page', 'bigger' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'blog',
		),
        'single_post'           => array(
			'title'       => esc_html__( 'Single Post', 'bigger' ),
			'description' => '',
			'priority'    => 10,
			'capability'  => 'edit_theme_options',
			'panel'       => 'blog',
		),
	);

	$fields = array(
		// Blog Page
		'blog_layout'           => array(
			'type'        => 'radio-image',
			'label'       => esc_html__( 'Blog Layout', 'bigger' ),
			'section'     => 'blog_page',
			'default'     => 'content-sidebar',
			'priority'    => 9,
			'description' => esc_html__( 'Select default sidebar for the blog page.', 'bigger' ),
			'choices'     => array(
				'content-sidebar' 	=> get_template_directory_uri() . '/inc/backend/images/right.png',
				'sidebar-content' 	=> get_template_directory_uri() . '/inc/backend/images/left.png',
				'full-content' 		=> get_template_directory_uri() . '/inc/backend/images/full.png',
			)
		),
		'post_entry_meta'              => array(
            'type'     => 'multicheck',
            'label'    => esc_html__( 'Entry Meta', 'bigger' ),
            'section'  => 'blog_page',
            'default'  => array( 'date', 'author', 'cat' ),
            'choices'  => array(
                'date'    => esc_html__( 'Date', 'bigger' ),
                'cat'     => esc_html__( 'Categories', 'bigger' ),
                'author'  => esc_html__( 'Author', 'bigger' ),
            ),
            'priority' => 10,
        ),
		'blog_read_more'               => array(
			'type'            => 'text',
			'label'           => esc_html__( 'Read More Button', 'bigger' ),
			'section'         => 'blog_page',
			'default'         => esc_html__( 'Read more', 'bigger' ),
			'priority'        => 11,
		),

        // Single Post
		'single_post_layout'           => array(
            'type'        => 'radio-image',
            'label'       => esc_html__( 'Single Post Layout', 'bigger' ),
            'section'     => 'single_post',
            'default'     => 'content-sidebar',
            'priority'    => 10,
            'description' => esc_html__( 'Select default sidebar for the single post page.', 'bigger' ),
            'choices'     => array(
				'content-sidebar' 	=> get_template_directory_uri() . '/inc/backend/images/right.png',
				'sidebar-content' 	=> get_template_directory_uri() . '/inc/backend/images/left.png',
				'full-content' 		=> get_template_directory_uri() . '/inc/backend/images/full.png',
			)
        ),
        'excerpt_length'			   => array(
        	'type'            => 'number',
        	'label'           => esc_html__( 'Excerpt Length', 'bigger' ),
			'section'         => 'single_post',
			'default'     => '30',
			'priority'    => 10,
        ),
        'post_custom_field_1'          => array(
            'type'    => 'custom',
            'section' => 'single_post',
            'default' => '<hr/>',
        ),

	);

	$settings['panels']   = apply_filters( 'bigger_customize_panels', $panels );
	$settings['sections'] = apply_filters( 'bigger_customize_sections', $sections );
	$settings['fields']   = apply_filters( 'bigger_customize_fields', $fields );

	return $settings;
}

$bigger_customize = new Bigger_Customize( blog_customize_settings() );