<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Bigger
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<header id="site-header" class="site-header <?php bigger_header_class(); ?>">
		<?php 
			if( bigger_get_option('header_layout') == "header2" ){
				get_template_part('inc/frontend/headers/header-2');
			}elseif( bigger_get_option('header_layout') == "header3" ) {
				get_template_part('inc/frontend/headers/header-3');
			}elseif( bigger_get_option('header_layout') == "header4" ) {
				get_template_part('inc/frontend/headers/header-4');
			}else{
	    ?>
		<!-- Top bar start -->
		<?php if( bigger_get_option('topbar_switch') != false ){ ?>
		<div id="header_topbar" class="top-bar md-hidden sm-hidden">
			<div class="container container-bigger">
				<div class="inner-top dtable">
					<div id="logo-header" class="site-logo dcell">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<img <?php if ( bigger_get_option('logo_scroll') != '' ) { ?>class="logo-static"<?php } ?> src="<?php echo esc_url(bigger_get_option('logo')) ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
							<?php if ( bigger_get_option('logo_scroll') && bigger_get_option('header_desktop_sticky') ) { ?>
								<img class="logo-scroll" src="<?php echo esc_url(bigger_get_option('logo_scroll')) ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
							<?php } ?>
						</a>
					</div>
					<?php if ( bigger_get_option('info_switch') != false ){ 
						$contact_infos = bigger_get_option( 'header_contact_info', array() );
						if( $contact_infos ){
					?>
					<div class="info-top dcell"><!-- contact info -->
						<ul class="info-list unstyle">
							<?php foreach ( $contact_infos as $contact_info ) { ?>
								<li>
									<?php if($contact_info['info_icon'] != '') echo wp_specialchars_decode($contact_info['info_icon']); ?>
									<?php echo wp_specialchars_decode($contact_info['info_content']); ?>
								</li>
							<?php } ?>
						</ul><!-- contact info close -->
					</div>
					<?php } } $btns = bigger_get_option( 'cta_top', array() ); if( $btns ){ ?>
					<div class="btn-cta-header dcell text-right">
						<?php foreach( $btns as $btn ){ ?>
							<a href="<?php echo esc_url($btn['btn_link']); ?>" class="btn"><?php echo esc_html($btn['btn_text']); ?></a>
						<?php } ?>
					</div>
					<?php } ?>
				</div>
			</div>
		</div>
		<?php } ?>
		<!-- Top bar close -->

		<!-- Main header start -->
		<div class="main-header md-hidden sm-hidden">
			<div class="container container-bigger">
				<div class="header-mainnav">
					<div class="search-cart-box f-right">

						<?php if ( bigger_get_option('search_switch') != false ){ ?>
							<div class="toggle_search f-right"><i class="fas fa-search"></i></div>
							<div class="h-search-form-field">
								<?php get_search_form(); ?>
							</div>	
						<?php } ?>
						
						<?php if ( class_exists( 'woocommerce' ) ) {?>
						<div class="h-cart-btn f-right">
							<a class="cart-contents" href=""><i class="fas fa-shopping-cart"></i></a>
						</div>
						<?php } ?>
						
					</div>
					<nav id="site-navigation" class="main-navigation f-right">			
						<?php
							wp_nav_menu( array(
								'theme_location' => 'primary',
								'menu_id'        => 'primary-menu',
								'menu_class'     => 'menu',
								'container'		 =>	'',
							) );
						?>
					</nav><!-- #site-navigation -->
				</div>
			</div>
		</div>
		<!-- Main header close -->
		<?php } ?>

		<?php get_template_part('inc/frontend/header-mobile');  ?>

	</header><!-- #site-header -->

	<div id="content" class="site-content">
		
	<?php bigger_page_header(); ?>