<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Bigger
 */

?>

	</div><!-- #content -->

	<footer id="site-footer" class="site-footer">
		<?php if( bigger_get_option('footer_widgets') ){ if ( is_active_sidebar( 'footer-area-1' ) || is_active_sidebar( 'footer-area-2' ) || is_active_sidebar( 'footer-area-3' ) || is_active_sidebar( 'footer-area-4' ) ){ ?>
			<div class="main-footer section-padd">
		    	<div class="container">
			    	<div class="row">
			    		<?php get_sidebar('footer');?>
			    	</div>
			    </div>
		    </div><!-- .main-footer -->
		<?php } } if( bigger_get_option('footer_bottom') ){ ?>
		<div class="bot-footer">
			<div class="container container-bigger">
				
				<div class="dtable bottom-content">
					<div id="logo-footer" class="site-logo dcell">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<img src="<?php echo bigger_get_option('logo_footer'); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
						</a>
					</div>
					<?php $socials = bigger_get_option('socials_contact', array()); if($socials){ ?>
					<div class="socials-footer text-center dcell">
						<ul class="socials">
							<?php foreach ($socials as $social) { ?>
							<li>
								<a href="<?php echo esc_url( $social['social_link'] ); ?>"><?php echo wp_specialchars_decode( $social['social_icon'] ); ?></a>
							</li>
		                	<?php } ?>
		                </ul>
		            </div>
		            <?php } if( bigger_get_option('copyright') ){ ?>
		            <div class="footer-copyright dcell text-right">
	                	<?php echo wp_kses( bigger_get_option('copyright'), wp_kses_allowed_html('post') ); ?>
	                </div>
	            	<?php } ?>
	                <div class="footer-nav dcell text-right">
	            		<?php
							wp_nav_menu( array(
								'theme_location' => 'footer',
								'menu_id'        => 'footer-menu',
								'menu_class'     => 'footer-menu',
								'container'      => '',
							) );
						?>
	            	</div>
            	</div>
			</div>
		</div><!-- .copyright-footer -->
		<?php } ?>
	</footer><!-- #site-footer -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
